/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependencies;

import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public final class PlatformClassifierFactory {
    private static final Map<String, String> LINUX_MAPPING = Map.of("aarch64", "linux-aarch_64", "amd64", "linux-x86_64", "ppc64", "linux-ppcle_64", "ppc64le", "linux-ppcle_64", "s390x", "linux-s390_64", "zarch_64", "linux-s390_64");
    private static final Map<String, String> MAC_OS_MAPPING = Map.of("aarch64", "osx-aarch_64", "amd64", "osx-x86_64", "x86_64", "osx-x86_64");
    private static final Map<String, String> WINDOWS_MAPPING = Map.of("amd64", "windows-x86_64", "x86", "windows-x86_32", "x86_32", "windows-x86_32", "x86_64", "windows-x86_64");
    private static final Map<String, String> FALLBACK_MAPPING = Map.of();
    private final HostSystem hostSystem;

    @Inject
    public PlatformClassifierFactory(HostSystem hostSystem) {
        this.hostSystem = hostSystem;
    }

    public String getClassifier(String binaryName) throws ResolutionException {
        String rawArch;
        Map<String, String> osMapping = this.hostSystem.isProbablyLinux() ? LINUX_MAPPING : (this.hostSystem.isProbablyMacOs() ? MAC_OS_MAPPING : (this.hostSystem.isProbablyWindows() ? WINDOWS_MAPPING : FALLBACK_MAPPING));
        String classifier = osMapping.get(rawArch = this.hostSystem.getCpuArchitecture());
        if (classifier != null) {
            return classifier;
        }
        String rawOs = this.hostSystem.getOperatingSystem();
        throw new ResolutionException("No '" + binaryName + "' binary is available for reported OS '" + rawOs + "' and CPU architecture '" + rawArch + "'");
    }
}

