/*
 * Decompiled with CFR 0.152.
 */
package tech.amikos.chromadb.embeddings.ollama;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import tech.amikos.chromadb.Constants;
import tech.amikos.chromadb.EFException;
import tech.amikos.chromadb.Embedding;
import tech.amikos.chromadb.embeddings.EmbeddingFunction;
import tech.amikos.chromadb.embeddings.WithParam;
import tech.amikos.chromadb.embeddings.ollama.CreateEmbeddingRequest;
import tech.amikos.chromadb.embeddings.ollama.CreateEmbeddingResponse;

public class OllamaEmbeddingFunction
implements EmbeddingFunction {
    public static final String DEFAULT_BASE_API = "http://localhost:11434/api/embed";
    public static final String DEFAULT_MODEL_NAME = "nomic-embed-text";
    private final OkHttpClient client = new OkHttpClient();
    private final Gson gson = new Gson();
    private final Map<String, Object> configParams = new HashMap<String, Object>();
    private static final List<WithParam> defaults = Arrays.asList(WithParam.baseAPI("http://localhost:11434/api/embed"), WithParam.defaultModel("nomic-embed-text"));

    public OllamaEmbeddingFunction() throws EFException {
        for (WithParam param : defaults) {
            param.apply(this.configParams);
        }
    }

    public OllamaEmbeddingFunction(WithParam ... params) throws EFException {
        for (WithParam param : defaults) {
            param.apply(this.configParams);
        }
        for (WithParam param : params) {
            param.apply(this.configParams);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CreateEmbeddingResponse createEmbedding(CreateEmbeddingRequest req) throws EFException {
        Request request = new Request.Builder().url(this.configParams.get("baseAPI").toString()).post(RequestBody.create((String)req.json(), (MediaType)Constants.JSON)).addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").addHeader("User-Agent", "chroma-java-client").build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            String responseData = response.body().string();
            CreateEmbeddingResponse createEmbeddingResponse = (CreateEmbeddingResponse)this.gson.fromJson(responseData, CreateEmbeddingResponse.class);
            return createEmbeddingResponse;
        }
        catch (IOException e) {
            throw new EFException(e);
        }
    }

    @Override
    public Embedding embedQuery(String query) throws EFException {
        CreateEmbeddingResponse response = this.createEmbedding(new CreateEmbeddingRequest().model(this.configParams.get("modelName").toString()).input(new String[]{query}));
        return new Embedding(response.getEmbeddings().get(0));
    }

    @Override
    public List<Embedding> embedDocuments(List<String> documents) throws EFException {
        CreateEmbeddingResponse response = this.createEmbedding(new CreateEmbeddingRequest().model(this.configParams.get("modelName").toString()).input(documents.toArray(new String[0])));
        return response.getEmbeddings().stream().map(Embedding::new).collect(Collectors.toList());
    }

    @Override
    public List<Embedding> embedDocuments(String[] documents) throws EFException {
        return this.embedDocuments(Arrays.asList(documents));
    }
}

