/*
 * Decompiled with CFR 0.152.
 */
package tech.amikos.chromadb.embeddings.cohere;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;

public class CreateEmbeddingRequest {
    @SerializedName(value="model")
    private String model = "embed-english-v2.0";
    @SerializedName(value="texts")
    private String[] texts;
    @SerializedName(value="truncate")
    private TruncateMode truncateMode = TruncateMode.END;
    @SerializedName(value="compress")
    private Boolean compress;
    @SerializedName(value="compression_codebook")
    private String compressionCodebook;
    @SerializedName(value="input_type")
    private String inputType = "search_document";

    public CreateEmbeddingRequest model(String model) {
        this.model = model;
        return this;
    }

    public CreateEmbeddingRequest texts(String[] texts) {
        this.texts = texts;
        return this;
    }

    public CreateEmbeddingRequest truncateMode(TruncateMode truncateMode) {
        this.truncateMode = truncateMode;
        return this;
    }

    public CreateEmbeddingRequest compress(Boolean compress) {
        this.compress = compress;
        return this;
    }

    public CreateEmbeddingRequest compressionCodebook(String compressionCodebook) {
        this.compressionCodebook = compressionCodebook;
        return this;
    }

    public CreateEmbeddingRequest inputType(String inputType) {
        this.inputType = inputType;
        return this;
    }

    public String json() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(TruncateMode.class, (Object)new TruncateModeSerializer());
        Gson customGson = gsonBuilder.create();
        return customGson.toJson((Object)this);
    }

    public String toString() {
        return this.json();
    }

    public static class TruncateModeSerializer
    implements JsonSerializer<TruncateMode> {
        public JsonElement serialize(TruncateMode src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString().toUpperCase());
        }
    }

    public static enum TruncateMode {
        NONE,
        START,
        END;

    }
}

