/*
 * Decompiled with CFR 0.152.
 */
package io.github.agileek.maven;

import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JEnumConstant;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JMethod;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class ChecksumFlywayMojo
extends AbstractMojo {
    @Parameter(name="locations", required=false)
    String[] locations;
    @Parameter(name="location", defaultValue="/db/migration")
    String location;
    @Parameter(name="outputDirectory", defaultValue="${project.build.directory}/generated-sources")
    String outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.locations == null || this.locations.length == 0) {
                this.locations = new String[]{this.location};
            }
            JCodeModel javaFile = this.generateEnumWithFilesChecksum(this.getJavaFiles(this.project.getCompileSourceRoots(), this.locations));
            File file = new File(this.outputDirectory);
            file.mkdirs();
            javaFile.build(file, (PrintStream)null);
        }
        catch (Exception e) {
            throw new MojoFailureException("Failure", (Throwable)e);
        }
    }

    JCodeModel generateEnumWithFilesChecksum(List<File> files) throws JClassAlreadyExistsException {
        JCodeModel codeModel = new JCodeModel();
        JDefinedClass enumClass = codeModel._class("io.github.agileek.flyway.JavaMigrationChecksums", EClassType.ENUM);
        JFieldVar checksumField = enumClass.field(12, Integer.TYPE, "checksum");
        JMethod enumConstructor = enumClass.constructor(4);
        enumConstructor.param(Integer.TYPE, "checksum");
        enumConstructor.body().assign((IJAssignmentTarget)JExpr._this().ref("checksum"), (IJExpression)JExpr.ref((String)"checksum"));
        JMethod getterColumnMethod = enumClass.method(1, Integer.TYPE, "getChecksum");
        getterColumnMethod.body()._return((IJExpression)checksumField);
        for (File file : files) {
            JEnumConstant enumConst = enumClass.enumConstant(file.getName().split("\\.")[0]);
            enumConst.arg((IJExpression)JExpr.lit((int)this.computeFileChecksum(file)));
        }
        return codeModel;
    }

    List<File> getJavaFiles(List<String> compileSourceRoots, String ... locations) {
        ArrayList<File> files = new ArrayList<File>();
        for (String compileSourceRoot : compileSourceRoots) {
            for (String location : locations) {
                File file = new File(compileSourceRoot + location);
                File[] java = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".java");
                    }
                });
                if (java == null) continue;
                Collections.addAll(files, java);
            }
        }
        return files;
    }

    int computeFileChecksum(File file) {
        CRC32 crc32 = new CRC32();
        try {
            RandomAccessFile r = new RandomAccessFile(file, "r");
            byte[] b = new byte[(int)r.length()];
            r.readFully(b);
            crc32.update(b);
        }
        catch (IOException e) {
            String message = "Unable to calculate checksum for " + file.getAbsolutePath();
            throw new RuntimeException(message, e);
        }
        return (int)crc32.getValue();
    }
}

