/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.a2a.client.http.A2AHttpClient;
import io.a2a.client.http.A2AHttpResponse;
import io.a2a.client.http.JdkA2AHttpClient;
import io.a2a.spec.A2AClientError;
import io.a2a.spec.A2AClientJSONError;
import io.a2a.spec.AgentCard;
import io.a2a.util.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class A2ACardResolver {
    private final A2AHttpClient httpClient;
    private final String url;
    private final Map<String, String> authHeaders;
    private static final String DEFAULT_AGENT_CARD_PATH = "/.well-known/agent-card.json";
    private static final TypeReference<AgentCard> AGENT_CARD_TYPE_REFERENCE = new TypeReference<AgentCard>(){};

    public A2ACardResolver(String baseUrl) throws A2AClientError {
        this(new JdkA2AHttpClient(), baseUrl, null, null);
    }

    public A2ACardResolver(A2AHttpClient httpClient, String baseUrl) throws A2AClientError {
        this(httpClient, baseUrl, null, null);
    }

    public A2ACardResolver(A2AHttpClient httpClient, String baseUrl, String agentCardPath) throws A2AClientError {
        this(httpClient, baseUrl, agentCardPath, null);
    }

    public A2ACardResolver(A2AHttpClient httpClient, String baseUrl, String agentCardPath, Map<String, String> authHeaders) throws A2AClientError {
        this.httpClient = httpClient;
        agentCardPath = agentCardPath == null || agentCardPath.isEmpty() ? DEFAULT_AGENT_CARD_PATH : agentCardPath;
        try {
            this.url = new URI(baseUrl).resolve(agentCardPath).toString();
        }
        catch (URISyntaxException e) {
            throw new A2AClientError("Invalid agent URL", (Throwable)e);
        }
        this.authHeaders = authHeaders;
    }

    public AgentCard getAgentCard() throws A2AClientError, A2AClientJSONError {
        String body;
        A2AHttpClient.GetBuilder builder = (A2AHttpClient.GetBuilder)((A2AHttpClient.GetBuilder)this.httpClient.createGet().url(this.url)).addHeader("Content-Type", "application/json");
        if (this.authHeaders != null) {
            for (Map.Entry<String, String> entry : this.authHeaders.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        try {
            A2AHttpResponse response = builder.get();
            if (!response.success()) {
                throw new A2AClientError("Failed to obtain agent card: " + response.status());
            }
            body = response.body();
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientError("Failed to obtain agent card", (Throwable)e);
        }
        try {
            return (AgentCard)Utils.unmarshalFrom((String)body, AGENT_CARD_TYPE_REFERENCE);
        }
        catch (JsonProcessingException e) {
            throw new A2AClientJSONError("Could not unmarshal agent card response", (Throwable)e);
        }
    }
}

