/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.engine;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.getunleash.engine.StatusCode;
import io.getunleash.engine.YggdrasilError;

class YggResponse<T> {
    final StatusCode statusCode;
    final T value;
    final String errorMessage;

    @JsonCreator
    YggResponse(@JsonProperty(value="status_code") StatusCode statusCode, @JsonProperty(value="value") T value, @JsonProperty(value="error_message") String errorMessage) {
        this.statusCode = statusCode;
        this.value = value;
        this.errorMessage = errorMessage;
    }

    boolean isValid() {
        return !StatusCode.Error.equals((Object)this.statusCode);
    }

    public T getValue() throws YggdrasilError {
        if (this.isValid()) {
            return this.value;
        }
        if (this.statusCode == null || this.statusCode.equals((Object)StatusCode.Error)) {
            throw new IllegalStateException("statusCode is null");
        }
        return null;
    }

    public String toString() {
        return "YggResponse{statusCode=" + (Object)((Object)this.statusCode) + ", value=" + this.value + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }
}

