/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.engine;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import io.getunleash.engine.Context;
import io.getunleash.engine.CustomStrategiesEvaluator;
import io.getunleash.engine.FeatureDef;
import io.getunleash.engine.IStrategy;
import io.getunleash.engine.MetricsBucket;
import io.getunleash.engine.UnleashFFI;
import io.getunleash.engine.VariantDef;
import io.getunleash.engine.YggResponse;
import io.getunleash.engine.YggdrasilError;
import io.getunleash.engine.YggdrasilInvalidInputException;
import io.getunleash.engine.YggdrasilParseException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnleashEngine {
    private static final String EMPTY_STRATEGY_RESULTS = "{}";
    private static final Logger log = LoggerFactory.getLogger(UnleashEngine.class);
    private final UnleashFFI yggdrasil;
    private final Pointer enginePtr;
    private final ObjectMapper mapper;
    private final CustomStrategiesEvaluator customStrategiesEvaluator;
    private Object cleaner = UnleashEngine.setupCleaner();

    public UnleashEngine() {
        this(UnleashFFI.getInstance(), null, null);
    }

    public UnleashEngine(List<IStrategy> customStrategies) {
        this(UnleashFFI.getInstance(), customStrategies, null);
    }

    public UnleashEngine(List<IStrategy> customStrategies, IStrategy fallbackStrategy) {
        this(UnleashFFI.getInstance(), customStrategies, fallbackStrategy);
    }

    UnleashEngine(UnleashFFI ffi, List<IStrategy> customStrategies, IStrategy fallbackStrategy) {
        this.yggdrasil = ffi;
        this.enginePtr = this.yggdrasil.newEngine();
        if (UnleashEngine.cleanerIsSupported()) {
            this.registerWithCleaner(this, this.enginePtr);
        }
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new JavaTimeModule());
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (customStrategies != null && !customStrategies.isEmpty()) {
            List<String> builtInStrategies = this.readRaw(this.yggdrasil.builtInStrategies(), new TypeReference<List<String>>(){});
            this.customStrategiesEvaluator = new CustomStrategiesEvaluator(customStrategies.stream().filter(strategy -> {
                if (builtInStrategies.contains(strategy.getName())) {
                    log.warn("Custom strategy {} is already a built-in strategy. Skipping.", (Object)strategy.getName());
                    return false;
                }
                return true;
            }), fallbackStrategy);
        } else {
            this.customStrategiesEvaluator = new CustomStrategiesEvaluator(Stream.empty(), fallbackStrategy);
        }
    }

    public void takeState(String toggles) throws YggdrasilInvalidInputException, YggdrasilError {
        this.read(this.yggdrasil.takeState(this.enginePtr, UnleashEngine.toUtf8Pointer(toggles)), new TypeReference<YggResponse<Void>>(){});
        this.customStrategiesEvaluator.loadStrategiesFor(toggles);
    }

    public Boolean isEnabled(String name, Context context) throws YggdrasilInvalidInputException, YggdrasilError {
        try {
            String jsonContext = this.mapper.writeValueAsString((Object)context);
            String strategyResults = this.customStrategiesEvaluator.eval(name, context);
            Boolean isEnabled = this.read(this.yggdrasil.checkEnabled(this.enginePtr, UnleashEngine.toUtf8Pointer(name), UnleashEngine.toUtf8Pointer(jsonContext), UnleashEngine.toUtf8Pointer(strategyResults)), new TypeReference<YggResponse<Boolean>>(){});
            return isEnabled;
        }
        catch (JsonProcessingException e) {
            throw new YggdrasilInvalidInputException(context);
        }
    }

    public VariantDef getVariant(String name, Context context) throws YggdrasilInvalidInputException, YggdrasilError {
        try {
            String jsonContext = this.mapper.writeValueAsString((Object)context);
            VariantDef response = this.read(this.yggdrasil.checkVariant(this.enginePtr, UnleashEngine.toUtf8Pointer(name), UnleashEngine.toUtf8Pointer(jsonContext), UnleashEngine.toUtf8Pointer(EMPTY_STRATEGY_RESULTS)), new TypeReference<YggResponse<VariantDef>>(){});
            return response;
        }
        catch (JsonProcessingException e) {
            throw new YggdrasilInvalidInputException(context);
        }
    }

    public void countToggle(String flagName, boolean enabled) {
        this.yggdrasil.countToggle(this.enginePtr, UnleashEngine.toUtf8Pointer(flagName), enabled);
    }

    public void countVariant(String flagName, String variantName) {
        this.yggdrasil.countVariant(this.enginePtr, UnleashEngine.toUtf8Pointer(flagName), UnleashEngine.toUtf8Pointer(variantName));
    }

    public MetricsBucket getMetrics() throws YggdrasilError {
        MetricsBucket response = this.read(this.yggdrasil.getMetrics(this.enginePtr), new TypeReference<YggResponse<MetricsBucket>>(){});
        return response;
    }

    public boolean shouldEmitImpressionEvent(String name) throws YggdrasilError {
        Boolean response = this.read(this.yggdrasil.shouldEmitImpressionEvent(this.enginePtr, UnleashEngine.toUtf8Pointer(name)), new TypeReference<YggResponse<Boolean>>(){});
        return response;
    }

    public List<FeatureDef> listKnownToggles() throws YggdrasilError {
        List<FeatureDef> response = this.read(this.yggdrasil.listKnownToggles(this.enginePtr), new TypeReference<YggResponse<List<FeatureDef>>>(){});
        return response;
    }

    public static String getCoreVersion() {
        Pointer versionPointer = UnleashFFI.getYggdrasilCoreVersion();
        return versionPointer.getString(0L);
    }

    private <T> T read(Pointer pointer, TypeReference<YggResponse<T>> clazz) throws YggdrasilError {
        YggResponse<T> wrappedResponse = this.readRaw(pointer, clazz);
        if (wrappedResponse.isValid()) {
            return wrappedResponse.getValue();
        }
        throw new YggdrasilError(wrappedResponse.errorMessage);
    }

    private <T> T readRaw(Pointer pointer, TypeReference<T> clazz) {
        try {
            Object object;
            String str = pointer.getString(0L, StandardCharsets.UTF_8.toString());
            try {
                object = this.mapper.readValue(str, clazz);
            }
            catch (IOException e) {
                log.error("Failed to parse response from Yggdrasil: {}", (Object)str, (Object)e);
                throw new YggdrasilParseException(str, clazz.getClass(), e);
            }
            return (T)object;
        }
        finally {
            this.yggdrasil.freeResponse(pointer);
        }
    }

    static Pointer toUtf8Pointer(String str) {
        byte[] utf8Bytes = str.getBytes(StandardCharsets.UTF_8);
        Memory pointer = new Memory((long)(utf8Bytes.length + 1));
        pointer.write(0L, utf8Bytes, 0, utf8Bytes.length);
        pointer.setByte((long)utf8Bytes.length, (byte)0);
        return pointer;
    }

    static boolean cleanerIsSupported() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            int minorVersion = Integer.parseInt(version.substring(2, 3));
            return minorVersion > 8;
        }
        return true;
    }

    protected void finalize() {
        if (UnleashEngine.cleanerIsSupported()) {
            return;
        }
        try {
            if (this.enginePtr != null) {
                this.yggdrasil.freeEngine(this.enginePtr);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to release native resource: " + e.getMessage());
        }
    }

    private static Object setupCleaner() {
        if (!UnleashEngine.cleanerIsSupported()) {
            return null;
        }
        try {
            Class<?> cleanerClass = Class.forName("java.lang.ref.Cleaner");
            Method createMethod = cleanerClass.getMethod("create", new Class[0]);
            return createMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to dynamically load Cleaner", e);
        }
    }

    private void registerWithCleaner(UnleashEngine engine, Pointer enginePtr) {
        try {
            Class<?> cleanerClass = Class.forName("java.lang.ref.Cleaner");
            Method registerMethod = cleanerClass.getMethod("register", Object.class, Runnable.class);
            UnleashFFI ffiInstance = engine.yggdrasil;
            Runnable cleanupAction = () -> ffiInstance.freeEngine(enginePtr);
            registerMethod.invoke(this.cleaner, engine, cleanupAction);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to dynamically load Cleaner", e);
        }
    }
}

