/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.jniutils;

import java.io.IOException;
import lmcoursier.internal.shaded.coursier.jniutils.NativeApi;
import lmcoursier.internal.shaded.coursier.jniutils.TerminalSize;

public final class WindowsAnsiTerminal {
    public static TerminalSize terminalSize() throws IOException {
        String string = NativeApi.get().terminalSize();
        if (string.startsWith("error:")) {
            throw new IOException("Error getting terminal size: " + string.substring("error:".length()));
        }
        String[] stringArray = string.split(":", 2);
        if (stringArray.length != 2) {
            throw new RuntimeException("Unexpected output from native method: '" + string + "'");
        }
        return new TerminalSize(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
    }

    public static boolean enableAnsiOutput() throws IOException {
        String string = NativeApi.get().enableAnsiOutput();
        if (string.startsWith("error:")) {
            throw new IOException("Error enabling ANSI output: " + string.substring("error:".length()));
        }
        return Boolean.parseBoolean(string);
    }
}

