/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.cache;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;
import lmcoursier.internal.shaded.coursier.cache.ArchiveType;
import lmcoursier.internal.shaded.coursier.cache.ArchiveType$Gzip$;
import lmcoursier.internal.shaded.coursier.cache.ArchiveType$Tbz2$;
import lmcoursier.internal.shaded.coursier.cache.ArchiveType$Tgz$;
import lmcoursier.internal.shaded.coursier.cache.ArchiveType$Zip$;
import lmcoursier.internal.shaded.coursier.cache.UnArchiver$;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.tar.TarBZip2UnArchiver;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Left;
import scala.util.Right;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u000193q!\u0003\u0006\u0011\u0002G\u0005q\u0002C\u0003\u0017\u0001\u0019\u0005qcB\u00033\u0015!\u00051GB\u0003\n\u0015!\u0005A\u0007C\u00036\u0007\u0011\u0005aG\u0002\u00038\u0007\u0019A\u0004\"B\u001b\u0006\t\u0003Q\u0004\"\u0002\f\u0006\t\u0003i\u0004\"\u0002\"\u0004\t\u0003\u0019%AC+o\u0003J\u001c\u0007.\u001b<fe*\u00111BS\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003\u001b5\u000b\u0001bY8veNLWM]\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VMZ\u0001\bKb$(/Y2u)\u0015A2$I\u0016.!\t\t\u0012$\u0003\u0002\u001b%\t!QK\\5u\u0011\u0015a\u0012\u00011\u0001\u001e\u0003-\t'o\u00195jm\u0016$\u0016\u0010]3\u0011\u0005yyR\"\u0001\u0006\n\u0005\u0001R!aC!sG\"Lg/\u001a+za\u0016DQAI\u0001A\u0002\r\nq!\u0019:dQ&4X\r\u0005\u0002%S5\tQE\u0003\u0002'O\u0005\u0011\u0011n\u001c\u0006\u0002Q\u0005!!.\u0019<b\u0013\tQSE\u0001\u0003GS2,\u0007\"\u0002\u0017\u0002\u0001\u0004\u0019\u0013a\u00023fgR$\u0015N\u001d\u0005\u0006]\u0005\u0001\raL\u0001\n_Z,'o\u001e:ji\u0016\u0004\"!\u0005\u0019\n\u0005E\u0012\"a\u0002\"p_2,\u0017M\\\u0001\u000b+:\f%o\u00195jm\u0016\u0014\bC\u0001\u0010\u0004'\t\u0019\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002g\t\tB)\u001a4bk2$XK\\!sG\"Lg/\u001a:\u0014\u0007\u0015\u0001\u0012\b\u0005\u0002\u001f\u0001Q\t1\b\u0005\u0002=\u000b5\t1\u0001F\u0003\u0019}}\u0002\u0015\tC\u0003\u001d\u000f\u0001\u0007Q\u0004C\u0003#\u000f\u0001\u00071\u0005C\u0003-\u000f\u0001\u00071\u0005C\u0003/\u000f\u0001\u0007q&A\u0004eK\u001a\fW\u000f\u001c;\u0015\u0003e\n!\u0002\\7d_V\u00148/[3s\u0015\u0005!\u0015\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u0019+\u0015AB:iC\u0012,GM\u0003\u0002I\u000f*\u0011Q\"\u0013\u0006\u0002\t*\u0011ai\u0013\u0006\u0003\u00112\u0003")
public interface UnArchiver {
    public static UnArchiver default() {
        return UnArchiver$.MODULE$.default();
    }

    public void extract(ArchiveType var1, File var2, File var3, boolean var4);

    private static final class DefaultUnArchiver
    implements UnArchiver {
        @Override
        public void extract(ArchiveType archiveType, File archive, File destDir, boolean overwrite) {
            Right right;
            ArchiveType archiveType2 = archiveType;
            if (ArchiveType$Zip$.MODULE$.equals(archiveType2)) {
                right = package$.MODULE$.Right().apply((Object)new ZipUnArchiver());
            } else if (ArchiveType$Tgz$.MODULE$.equals(archiveType2)) {
                right = package$.MODULE$.Right().apply((Object)new TarGZipUnArchiver());
            } else if (ArchiveType$Tbz2$.MODULE$.equals(archiveType2)) {
                right = package$.MODULE$.Right().apply((Object)new TarBZip2UnArchiver());
            } else if (ArchiveType$Gzip$.MODULE$.equals(archiveType2)) {
                right = package$.MODULE$.Left().apply((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    File dest = new File(destDir, new StringOps(Predef$.MODULE$.augmentString(archive.getName())).stripSuffix(".gz"));
                    InputStream fis = null;
                    OutputStream fos = null;
                    GZIPInputStream gzis = null;
                    try {
                        fis = Files.newInputStream(archive.toPath(), new OpenOption[0]);
                        gzis = new GZIPInputStream(fis);
                        fos = Files.newOutputStream(dest.toPath(), new OpenOption[0]);
                        byte[] buf = (byte[])Array$.MODULE$.ofDim(16384, ClassTag$.MODULE$.Byte());
                        int read = -1;
                        while ((read = gzis.read(buf)) >= 0) {
                            if (read <= 0) continue;
                            fos.write(buf, 0, read);
                        }
                        fos.flush();
                    }
                    finally {
                        if (gzis != null) {
                            gzis.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                });
            } else {
                throw new MatchError((Object)archiveType2);
            }
            Right unArchiver = right;
            destDir.mkdirs();
            Right right2 = unArchiver;
            if (right2 instanceof Left) {
                Left left = (Left)right2;
                Function0 f = (Function0)left.value();
                f.apply$mcV$sp();
                return;
            }
            if (right2 instanceof Right) {
                Right right3 = right2;
                lmcoursier.internal.shaded.org.codehaus.plexus.archiver.UnArchiver u = (lmcoursier.internal.shaded.org.codehaus.plexus.archiver.UnArchiver)right3.value();
                u.setOverwrite(false);
                u.setSourceFile(archive);
                u.setDestDirectory(destDir);
                u.extract();
                return;
            }
            throw new MatchError((Object)right2);
        }
    }
}

