/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.paths;

import java.io.File;
import java.io.IOException;
import lmcoursier.internal.shaded.coursier.cache.shaded.dirs.dev.dirs.ProjectDirectories;
import lmcoursier.internal.shaded.coursier.paths.Util;

public final class CoursierPaths {
    private static final Object coursierDirectoriesLock = new Object();
    private static ProjectDirectories coursierDirectories0;
    private static final Object cacheDirectoryLock;
    private static volatile File cacheDirectory0;
    private static volatile File jvmCacheDirectory0;
    private static final Object configDirectoryLock;
    private static volatile File[] configDirectories0;
    private static final Object dataLocalDirectoryLock;
    private static volatile File dataLocalDirectory0;

    private CoursierPaths() {
        throw new Error();
    }

    private static String computeCacheDirectory() throws IOException {
        return CoursierPaths.computeCacheDirectory("COURSIER_CACHE", "lmcoursier.internal.shaded.coursier.cache", "v1");
    }

    private static String computeJvmCacheDirectory() throws IOException {
        return CoursierPaths.computeCacheDirectory("COURSIER_JVM_CACHE", "lmcoursier.internal.shaded.coursier.jvm.cache", "jvm");
    }

    private static String computeCacheDirectory(String string, String string2, String string3) throws IOException {
        String string4 = System.getenv(string);
        if (string4 == null) {
            string4 = System.getProperty(string2);
        }
        if (string4 != null) {
            return string4;
        }
        File file = new File(CoursierPaths.coursierDirectories().cacheDir);
        File file2 = new File(file, string3);
        Util.createDirectories(file2.toPath());
        return file2.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File cacheDirectory() throws IOException {
        if (cacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (cacheDirectory0 == null) {
                    cacheDirectory0 = new File(CoursierPaths.computeCacheDirectory()).getAbsoluteFile();
                }
            }
        }
        return cacheDirectory0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File jvmCacheDirectory() throws IOException {
        if (jvmCacheDirectory0 == null) {
            Object object = cacheDirectoryLock;
            synchronized (object) {
                if (jvmCacheDirectory0 == null) {
                    jvmCacheDirectory0 = new File(CoursierPaths.computeJvmCacheDirectory()).getAbsoluteFile();
                }
            }
        }
        return jvmCacheDirectory0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProjectDirectories coursierDirectories() throws IOException {
        if (coursierDirectories0 == null) {
            Object object = coursierDirectoriesLock;
            synchronized (object) {
                if (coursierDirectories0 == null) {
                    coursierDirectories0 = ProjectDirectories.from(null, null, "Coursier");
                }
            }
        }
        return coursierDirectories0;
    }

    private static File[] computeConfigDirectories() throws IOException {
        String string = System.getenv("COURSIER_CONFIG_DIR");
        if (string == null) {
            string = System.getProperty("lmcoursier.internal.shaded.coursier.config-dir");
        }
        if (string != null) {
            return new File[]{new File(string).getAbsoluteFile()};
        }
        String string2 = CoursierPaths.coursierDirectories().configDir;
        String string3 = CoursierPaths.coursierDirectories().preferenceDir;
        if (string2.equals(string3)) {
            return new File[]{new File(string2).getAbsoluteFile()};
        }
        return new File[]{new File(string2).getAbsoluteFile(), new File(string3).getAbsoluteFile()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] configDirectories() throws IOException {
        if (configDirectories0 == null) {
            Object object = configDirectoryLock;
            synchronized (object) {
                if (configDirectories0 == null) {
                    configDirectories0 = CoursierPaths.computeConfigDirectories();
                }
            }
        }
        return (File[])configDirectories0.clone();
    }

    @Deprecated
    public static File configDirectory() throws IOException {
        return CoursierPaths.configDirectories()[0];
    }

    public static File defaultConfigDirectory() throws IOException {
        return CoursierPaths.configDirectories()[0];
    }

    private static String computeDataLocalDirectory() throws IOException {
        String string = System.getenv("COURSIER_DATA_DIR");
        if (string == null) {
            string = System.getProperty("lmcoursier.internal.shaded.coursier.data-dir");
        }
        if (string != null) {
            return string;
        }
        return CoursierPaths.coursierDirectories().dataLocalDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File dataLocalDirectory() throws IOException {
        if (dataLocalDirectory0 == null) {
            Object object = dataLocalDirectoryLock;
            synchronized (object) {
                if (dataLocalDirectory0 == null) {
                    dataLocalDirectory0 = new File(CoursierPaths.computeDataLocalDirectory()).getAbsoluteFile();
                }
            }
        }
        return dataLocalDirectory0;
    }

    public static File projectCacheDirectory() throws IOException {
        return new File(CoursierPaths.coursierDirectories().cacheDir);
    }

    static {
        cacheDirectoryLock = new Object();
        cacheDirectory0 = null;
        jvmCacheDirectory0 = null;
        configDirectoryLock = new Object();
        configDirectories0 = null;
        dataLocalDirectoryLock = new Object();
        dataLocalDirectory0 = null;
    }
}

