/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.logging.console;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lmcoursier.internal.shaded.org.codehaus.plexus.logging.AbstractLoggerManager;
import lmcoursier.internal.shaded.org.codehaus.plexus.logging.Logger;
import lmcoursier.internal.shaded.org.codehaus.plexus.logging.LoggerManager;
import lmcoursier.internal.shaded.org.codehaus.plexus.logging.console.ConsoleLogger;
import lmcoursier.internal.shaded.org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;

public class ConsoleLoggerManager
extends AbstractLoggerManager
implements LoggerManager,
Initializable {
    private String threshold = "info";
    private int currentThreshold;
    private Map loggers;
    private int loggerCount;
    private boolean bootTimeLogger = false;

    public ConsoleLoggerManager() {
    }

    public ConsoleLoggerManager(String threshold) {
        this.threshold = threshold;
        this.bootTimeLogger = true;
        this.initialize();
    }

    @Override
    public void initialize() {
        this.debug("Initializing ConsoleLoggerManager: " + this.hashCode() + ".");
        this.currentThreshold = this.parseThreshold(this.threshold);
        if (this.currentThreshold == -1) {
            this.debug("Could not parse the threshold level: '" + this.threshold + "', setting to debug.");
            this.currentThreshold = 0;
        }
        this.loggers = new HashMap();
    }

    @Override
    public void setThreshold(int currentThreshold) {
        this.currentThreshold = currentThreshold;
    }

    @Override
    public void setThresholds(int currentThreshold) {
        this.currentThreshold = currentThreshold;
        for (Object o : this.loggers.values()) {
            Logger logger = (Logger)o;
            logger.setThreshold(currentThreshold);
        }
    }

    @Override
    public int getThreshold() {
        return this.currentThreshold;
    }

    @Override
    public void setThreshold(String role, String roleHint, int threshold) {
        String name = this.toMapKey(role, roleHint);
        ConsoleLogger logger = (ConsoleLogger)this.loggers.get(name);
        if (logger == null) {
            this.debug("Trying to set the threshold of a unknown logger '" + name + "'.");
            return;
        }
        logger.setThreshold(threshold);
    }

    @Override
    public int getThreshold(String role, String roleHint) {
        String name = this.toMapKey(role, roleHint);
        ConsoleLogger logger = (ConsoleLogger)this.loggers.get(name);
        if (logger == null) {
            this.debug("Trying to get the threshold of a unknown logger '" + name + "'.");
            return 0;
        }
        return logger.getThreshold();
    }

    public Logger createLogger(int threshold, String name) {
        return new ConsoleLogger(threshold, name);
    }

    @Override
    public Logger getLoggerForComponent(String role, String roleHint) {
        String name = this.toMapKey(role, roleHint);
        Logger logger = (Logger)this.loggers.get(name);
        if (logger != null) {
            return logger;
        }
        this.debug("Creating logger '" + name + "' " + this.hashCode() + ".");
        logger = this.createLogger(this.getThreshold(), name);
        this.loggers.put(name, logger);
        return logger;
    }

    @Override
    public void returnComponentLogger(String role, String roleHint) {
        String name = this.toMapKey(role, roleHint);
        Object obj = this.loggers.remove(name);
        if (obj == null) {
            this.debug("There was no such logger '" + name + "' " + this.hashCode() + ".");
        } else {
            this.debug("Removed logger '" + name + "' " + this.hashCode() + ".");
        }
    }

    @Override
    public int getActiveLoggerCount() {
        return this.loggers.size();
    }

    private int parseThreshold(String text2) {
        if ((text2 = text2.trim().toLowerCase(Locale.ENGLISH)).equals("debug")) {
            return 0;
        }
        if (text2.equals("info")) {
            return 1;
        }
        if (text2.equals("warn")) {
            return 2;
        }
        if (text2.equals("error")) {
            return 3;
        }
        if (text2.equals("fatal")) {
            return 4;
        }
        return -1;
    }

    private String decodeLogLevel(int logLevel) {
        switch (logLevel) {
            case 0: {
                return "debug";
            }
            case 1: {
                return "info";
            }
            case 2: {
                return "warn";
            }
            case 3: {
                return "error";
            }
            case 4: {
                return "fatal";
            }
            case 5: {
                return "disabled";
            }
        }
        return "unknown";
    }

    private void debug(String msg) {
    }
}

