/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.component.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lmcoursier.internal.shaded.org.codehaus.plexus.MutablePlexusContainer;
import lmcoursier.internal.shaded.org.codehaus.plexus.classworlds.ClassWorld;
import lmcoursier.internal.shaded.org.codehaus.plexus.classworlds.realm.ClassRealm;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.repository.ComponentDescriptor;
import lmcoursier.internal.shaded.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import lmcoursier.internal.shaded.org.codehaus.plexus.logging.Logger;

public abstract class AbstractComponentCollection<T> {
    protected MutablePlexusContainer container;
    protected final Class<T> componentType;
    protected String role;
    protected List<String> roleHints;
    protected String hostComponent;
    protected Logger logger;
    private ClassLoader tccl;
    private Collection<ClassRealm> realms;
    private Map<String, ComponentDescriptor<T>> componentDescriptorMap;
    private final ClassWorld world;

    public AbstractComponentCollection(MutablePlexusContainer container, Class<T> componentType, String role, List<String> roleHints, String hostComponent) {
        this.container = container;
        this.componentType = componentType;
        this.role = role;
        this.roleHints = roleHints;
        this.hostComponent = hostComponent;
        this.logger = container.getLoggerManager().getLoggerForComponent(role);
        this.world = container.getContainerRealm().getWorld();
    }

    private boolean realmsHaveChanged() {
        return this.tccl != Thread.currentThread().getContextClassLoader() || this.realms == null || !this.realms.equals(this.world.getRealms());
    }

    protected synchronized Map<String, ComponentDescriptor<T>> getComponentDescriptorMap() {
        this.checkUpdate();
        return this.componentDescriptorMap;
    }

    protected boolean checkUpdate() {
        if (this.componentDescriptorMap != null && !this.realmsHaveChanged()) {
            return false;
        }
        this.tccl = Thread.currentThread().getContextClassLoader();
        Collection<ClassRealm> fromWorld = this.world.getRealms();
        this.realms = fromWorld == null || fromWorld.isEmpty() ? null : new HashSet<ClassRealm>(fromWorld);
        Map<String, ComponentDescriptor<T>> componentMap = this.container.getComponentDescriptorMap(this.componentType, this.role);
        HashMap<String, ComponentDescriptor<T>> newComponentDescriptors = new HashMap<String, ComponentDescriptor<T>>(componentMap.size() * 2);
        if (this.roleHints != null && !this.roleHints.isEmpty()) {
            for (String roleHint : this.roleHints) {
                ComponentDescriptor<T> componentDescriptor = componentMap.get(roleHint);
                if (componentDescriptor == null) continue;
                newComponentDescriptors.put(roleHint, componentDescriptor);
            }
        } else {
            newComponentDescriptors.putAll(componentMap);
        }
        if (this.componentDescriptorMap == null || !newComponentDescriptors.equals(this.componentDescriptorMap)) {
            this.componentDescriptorMap = newComponentDescriptors;
            return true;
        }
        return false;
    }

    protected T lookup(ComponentDescriptor<T> componentDescriptor) {
        T component = null;
        try {
            if (componentDescriptor != null) {
                component = this.container.lookup(componentDescriptor);
            }
        }
        catch (ComponentLookupException e) {
            this.logger.debug("Failed to lookup a member of active collection with role: " + this.role + " and role-hint: " + componentDescriptor.getRoleHint(), e);
        }
        return component;
    }

    public synchronized void clear() {
        this.releaseAllCallback();
        this.componentDescriptorMap = null;
        this.tccl = null;
        this.realms = null;
    }

    protected abstract void releaseAllCallback();
}

