/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.archiver.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nonnull;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.attributes.AttributeUtils;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.functions.ResourceAttributeSupplier;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.AbstractPlexusIoResource;

public class PlexusIoVirtualFileResource
extends AbstractPlexusIoResource
implements ResourceAttributeSupplier {
    private final File file;

    protected PlexusIoVirtualFileResource(File file, String name) {
        super(name, file.lastModified(), file.length(), file.isFile(), file.isDirectory(), file.exists());
        this.file = file;
    }

    protected static String getName(File file) {
        return file.getPath().replace('\\', '/');
    }

    public File getFile() {
        return this.file;
    }

    @Override
    @Nonnull
    public InputStream getContents() throws IOException {
        throw new UnsupportedOperationException("We're not really sure we can do this");
    }

    @Override
    public URL getURL() throws IOException {
        return this.getFile().toURI().toURL();
    }

    @Override
    public long getSize() {
        return this.getFile().length();
    }

    @Override
    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    @Override
    public boolean isExisting() {
        return this.getFile().exists();
    }

    @Override
    public boolean isFile() {
        return this.getFile().isFile();
    }

    @Override
    public PlexusIoResourceAttributes getAttributes() {
        return null;
    }

    @Override
    public long getLastModified() {
        if (this.file.exists()) {
            return AttributeUtils.getLastModified(this.getFile());
        }
        return System.currentTimeMillis();
    }

    @Override
    public boolean isSymbolicLink() {
        return this.getAttributes().isSymbolicLink();
    }
}

