/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.archiver.manager;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import lmcoursier.internal.shaded.javax.inject.Inject;
import lmcoursier.internal.shaded.javax.inject.Named;
import lmcoursier.internal.shaded.javax.inject.Provider;
import lmcoursier.internal.shaded.javax.inject.Singleton;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.Archiver;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.UnArchiver;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.manager.ArchiverManager;
import lmcoursier.internal.shaded.org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import lmcoursier.internal.shaded.org.codehaus.plexus.util.FileUtils;
import lmcoursier.internal.shaded.org.codehaus.plexus.util.StringUtils;

@Singleton
@Named
public class DefaultArchiverManager
implements ArchiverManager {
    private final Map<String, Provider<Archiver>> archivers;
    private final Map<String, Provider<UnArchiver>> unArchivers;
    private final Map<String, Provider<PlexusIoResourceCollection>> plexusIoResourceCollections;

    @Inject
    public DefaultArchiverManager(Map<String, Provider<Archiver>> archivers, Map<String, Provider<UnArchiver>> unArchivers, Map<String, Provider<PlexusIoResourceCollection>> plexusIoResourceCollections) {
        this.archivers = Objects.requireNonNull(archivers);
        this.unArchivers = Objects.requireNonNull(unArchivers);
        this.plexusIoResourceCollections = Objects.requireNonNull(plexusIoResourceCollections);
    }

    @Override
    @Nonnull
    public Archiver getArchiver(@Nonnull String archiverName) throws NoSuchArchiverException {
        Objects.requireNonNull(archiverName);
        Provider<Archiver> archiver = this.archivers.get(archiverName);
        if (archiver == null) {
            throw new NoSuchArchiverException(archiverName);
        }
        return archiver.get();
    }

    @Override
    @Nonnull
    public UnArchiver getUnArchiver(@Nonnull String unArchiverName) throws NoSuchArchiverException {
        Objects.requireNonNull(unArchiverName);
        Provider<UnArchiver> unArchiver = this.unArchivers.get(unArchiverName);
        if (unArchiver == null) {
            throw new NoSuchArchiverException(unArchiverName);
        }
        return unArchiver.get();
    }

    @Override
    @Nonnull
    public PlexusIoResourceCollection getResourceCollection(String resourceCollectionName) throws NoSuchArchiverException {
        Objects.requireNonNull(resourceCollectionName);
        Provider<PlexusIoResourceCollection> resourceCollection = this.plexusIoResourceCollections.get(resourceCollectionName);
        if (resourceCollection == null) {
            throw new NoSuchArchiverException(resourceCollectionName);
        }
        return resourceCollection.get();
    }

    @Nonnull
    private static String getFileExtention(@Nonnull File file) {
        String[] tokens;
        String path = file.getAbsolutePath();
        String archiveExt = FileUtils.getExtension(path).toLowerCase(Locale.ENGLISH);
        if (("gz".equals(archiveExt) || "bz2".equals(archiveExt) || "xz".equals(archiveExt) || "zst".equals(archiveExt) || "snappy".equals(archiveExt)) && (tokens = StringUtils.split(path, ".")).length > 2 && "tar".equals(tokens[tokens.length - 2].toLowerCase(Locale.ENGLISH))) {
            archiveExt = "tar." + archiveExt;
        }
        return archiveExt;
    }

    @Override
    @Nonnull
    public Archiver getArchiver(@Nonnull File file) throws NoSuchArchiverException {
        return this.getArchiver(DefaultArchiverManager.getFileExtention(file));
    }

    @Override
    @Nonnull
    public UnArchiver getUnArchiver(@Nonnull File file) throws NoSuchArchiverException {
        return this.getUnArchiver(DefaultArchiverManager.getFileExtention(file));
    }

    @Override
    @Nonnull
    public PlexusIoResourceCollection getResourceCollection(@Nonnull File file) throws NoSuchArchiverException {
        return this.getResourceCollection(DefaultArchiverManager.getFileExtention(file));
    }
}

