/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.cache;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import lmcoursier.internal.shaded.coursier.cache.ArchiveCache$;
import lmcoursier.internal.shaded.coursier.cache.ArchiveType;
import lmcoursier.internal.shaded.coursier.cache.ArtifactError;
import lmcoursier.internal.shaded.coursier.cache.Cache;
import lmcoursier.internal.shaded.coursier.cache.CacheLocks$;
import lmcoursier.internal.shaded.coursier.cache.CacheLogger;
import lmcoursier.internal.shaded.coursier.cache.CacheLogger$;
import lmcoursier.internal.shaded.coursier.cache.FileCache$;
import lmcoursier.internal.shaded.coursier.cache.UnArchiver;
import lmcoursier.internal.shaded.coursier.cache.UnArchiver$;
import lmcoursier.internal.shaded.coursier.paths.CachePath;
import lmcoursier.internal.shaded.coursier.util.Artifact;
import lmcoursier.internal.shaded.coursier.util.Monad$ops$;
import lmcoursier.internal.shaded.coursier.util.Sync;
import lmcoursier.internal.shaded.coursier.util.Task;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\teb\u0001B\u0013'\u0005-B\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005w!Aq\u0005\u0001BC\u0002\u0013\u0005A\t\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003F\u0011!A\u0006A!b\u0001\n\u0003I\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011y\u0003!Q1A\u0005\u0004}C\u0001B\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006O\u0002!\ta\u001c\u0005\u0006g\u0002!Ia\u0018\u0005\u0006i\u0002!I!\u001e\u0005\u0006w\u0002!\t\u0001 \u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u0011Q\t\u0001\u0005B\u0005\u001d\u0003bBA+\u0001\u0011\u0005\u0013q\u000b\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\tI\u0007\u0001C!\u0003WBq!a\u001d\u0001\t\u0013\t)\bC\u0004\u0002~\u0001!\t%a \t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011Q\u0011\u0001\u0005B\u0005\u001duaBAGM!\u0005\u0011q\u0012\u0004\u0007K\u0019B\t!!%\t\r\u001ddB\u0011AAJ\u0011\u001d\t)\n\bC\u0001\u0003/C\u0011\"a+\u001d#\u0003%\t!!,\t\u000f\u0005MG\u0004\"\u0003\u0002V\"9\u0011\u0011\u001d\u000f\u0005\n\u0005\r\bbBAK9\u0011\u0005\u0011Q \u0005\b\u0003+cB\u0011\u0001B\n\u0011%\u0011y\u0003HA\u0001\n\u0013\u0011\tD\u0001\u0007Be\u000eD\u0017N^3DC\u000eDWM\u0003\u0002(Q\u0005)1-Y2iK*\t\u0011&\u0001\u0005d_V\u00148/[3s\u0007\u0001)\"\u0001L&\u0014\t\u0001i3G\u000e\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\"\u0014BA\u001b0\u0005\u001d\u0001&o\u001c3vGR\u0004\"AL\u001c\n\u0005az#\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00037pG\u0006$\u0018n\u001c8\u0016\u0003m\u0002\"\u0001P!\u000e\u0003uR!AP \u0002\u0005%|'\"\u0001!\u0002\t)\fg/Y\u0005\u0003\u0005v\u0012AAR5mK\u0006IAn\\2bi&|g\u000eI\u000b\u0002\u000bB\u0019aiR%\u000e\u0003\u0019J!\u0001\u0013\u0014\u0003\u000b\r\u000b7\r[3\u0011\u0005)[E\u0002\u0001\u0003\u0006\u0019\u0002\u0011\r!\u0014\u0002\u0002\rV\u0011a*V\t\u0003\u001fJ\u0003\"A\f)\n\u0005E{#a\u0002(pi\"Lgn\u001a\t\u0003]MK!\u0001V\u0018\u0003\u0007\u0005s\u0017\u0010B\u0003W\u0017\n\u0007aJA\u0001`\u0003\u0019\u0019\u0017m\u00195fA\u0005QQO\\!sG\"Lg/\u001a:\u0016\u0003i\u0003\"AR.\n\u0005q3#AC+o\u0003J\u001c\u0007.\u001b<fe\u0006YQO\\!sG\"Lg/\u001a:!\u0003\u0011\u0019\u0018P\\2\u0016\u0003\u0001\u00042!\u00193J\u001b\u0005\u0011'BA2)\u0003\u0011)H/\u001b7\n\u0005\u0015\u0014'\u0001B*z]\u000e\fQa]=oG\u0002\na\u0001P5oSRtD\u0003B5m[:$\"A[6\u0011\u0007\u0019\u0003\u0011\nC\u0003_\u0013\u0001\u000f\u0001\rC\u0003:\u0013\u0001\u00071\bC\u0003(\u0013\u0001\u0007Q\tC\u0003Y\u0013\u0001\u0007!\f\u0006\u0002qeR\u0011!.\u001d\u0005\u0006=*\u0001\u001d\u0001\u0019\u0005\u0006s)\u0001\raO\u0001\u0002'\u0006AAn\\2bY\u0012K'\u000f\u0006\u0002<m\")q\u000f\u0004a\u0001q\u0006A\u0011M\u001d;jM\u0006\u001cG\u000f\u0005\u0002bs&\u0011!P\u0019\u0002\t\u0003J$\u0018NZ1di\u0006Yq-\u001a;JM\u0016C\u0018n\u001d;t)\ri\u0018\u0011\u0005\t\u0004\u0015.s\bcB@\u0002\u0010\u0005U\u00111\u0004\b\u0005\u0003\u0003\tYA\u0004\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9AK\u0001\u0007yI|w\u000e\u001e \n\u0003AJ1!!\u00040\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0005\u0002\u0014\t1Q)\u001b;iKJT1!!\u00040!\r1\u0015qC\u0005\u0004\u000331#!D!si&4\u0017m\u0019;FeJ|'\u000f\u0005\u0003/\u0003;Y\u0014bAA\u0010_\t1q\n\u001d;j_:DQa^\u0007A\u0002a\f1aZ3u)\u0011\t9#a\u000b\u0011\t)[\u0015\u0011\u0006\t\u0007\u007f\u0006=\u0011QC\u001e\t\u000b]t\u0001\u0019\u0001=\u0002\u0019]LG\u000f\u001b'pG\u0006$\u0018n\u001c8\u0015\u0007)\f\t\u0004C\u0003:\u001f\u0001\u00071(A\u0005xSRD7)Y2iKR\u0019!.a\u000e\t\u000b\u001d\u0002\u0002\u0019A#\u0002\u001d]LG\u000f[+o\u0003J\u001c\u0007.\u001b<feR\u0019!.!\u0010\t\u000ba\u000b\u0002\u0019\u0001.\u0002\u0011]LG\u000f[*z]\u000e$2A[A\"\u0011\u0015q&\u00031\u0001a\u0003!!xn\u0015;sS:<GCAA%!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(\u007f\u0005!A.\u00198h\u0013\u0011\t\u0019&!\u0014\u0003\rM#(/\u001b8h\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA-\u0003?\u00022ALA.\u0013\r\tif\f\u0002\b\u0005>|G.Z1o\u0011\u0019\t\t\u0007\u0006a\u0001%\u0006\u0019qN\u00196\u0002\r\u0015\fX/\u00197t)\u0011\tI&a\u001a\t\r\u0005\u0005T\u00031\u0001S\u0003!A\u0017m\u001d5D_\u0012,GCAA7!\rq\u0013qN\u0005\u0004\u0003cz#aA%oi\u0006)A/\u001e9mKV\u0011\u0011q\u000f\t\b]\u0005e4(\u0012.a\u0013\r\tYh\f\u0002\u0007)V\u0004H.\u001a\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002n\u0005q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001*\u0002\n\"9\u00111\u0012\u000eA\u0002\u00055\u0014!\u00018\u0002\u0019\u0005\u00138\r[5wK\u000e\u000b7\r[3\u0011\u0005\u0019c2c\u0001\u000f.mQ\u0011\u0011qR\u0001\u0006CB\u0004H._\u000b\u0005\u00033\u000b\t\u000b\u0006\u0002\u0002\u001cR!\u0011QTAT!\u00111\u0005!a(\u0011\u0007)\u000b\t\u000b\u0002\u0004M=\t\u0007\u00111U\u000b\u0004\u001d\u0006\u0015FA\u0002,\u0002\"\n\u0007a\n\u0003\u0005t=A\u0005\t9AAU!\u0011\tG-a(\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE*B!a,\u0002NR\u0011\u0011\u0011\u0017\u0016\u0005\u0003g\u000bY\f\u0005\u0003bI\u0006U\u0006cA1\u00028&\u0019\u0011\u0011\u00182\u0003\tQ\u000b7o[\u0016\u0003\u0003{\u0003B!a0\u0002J6\u0011\u0011\u0011\u0019\u0006\u0005\u0003\u0007\f)-A\u0005v]\u000eDWmY6fI*\u0019\u0011qY\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002L\u0006\u0005'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00121Aj\bb\u0001\u0003\u001f,2ATAi\t\u00191\u0016Q\u001ab\u0001\u001d\u0006yA-\u001a7fi\u0016\u0014VmY;sg&4X\r\u0006\u0003\u0002X\u0006u\u0007c\u0001\u0018\u0002Z&\u0019\u00111\\\u0018\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003?\u0004\u0003\u0019A\u001e\u0002\u0003\u0019\f1\"\u0019:dQ&4X\rV=qKR!\u0011Q]Av!\r1\u0015q]\u0005\u0004\u0003S4#aC!sG\"Lg/\u001a+za\u0016Dq!!<\"\u0001\u0004\ty/A\u0002ve2\u0004B!!=\u0002z:!\u00111_A{!\r\t\u0019aL\u0005\u0004\u0003o|\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002T\u0005m(bAA|_U!\u0011q B\u0004)\u0011\u0011\tA!\u0005\u0015\t\t\r!Q\u0002\t\u0005\r\u0002\u0011)\u0001E\u0002K\u0005\u000f!a\u0001\u0014\u0012C\u0002\t%Qc\u0001(\u0003\f\u00111aKa\u0002C\u00029CaA\u0018\u0012A\u0004\t=\u0001\u0003B1e\u0005\u000bAQ!\u000f\u0012A\u0002m*BA!\u0006\u0003\u001eQA!q\u0003B\u0014\u0005S\u0011i\u0003\u0006\u0003\u0003\u001a\t\r\u0002\u0003\u0002$\u0001\u00057\u00012A\u0013B\u000f\t\u0019a5E1\u0001\u0003 U\u0019aJ!\t\u0005\rY\u0013iB1\u0001O\u0011\u0019q6\u0005q\u0001\u0003&A!\u0011\r\u001aB\u000e\u0011\u0015I4\u00051\u0001<\u0011\u001993\u00051\u0001\u0003,A!ai\u0012B\u000e\u0011\u0015A6\u00051\u0001[\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tM\u0002\u0003BA&\u0005kIAAa\u000e\u0002N\t1qJ\u00196fGR\u0004")
public final class ArchiveCache<F>
implements Product,
scala.Serializable {
    private final File location;
    private final Cache<F> cache;
    private final UnArchiver unArchiver;
    private final Sync<F> sync;

    public static <F> ArchiveCache<F> apply(File file, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(file, cache, unArchiver, sync);
    }

    public static <F> ArchiveCache<F> apply(File file, Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(file, sync);
    }

    public static <F> Sync<Task> apply$default$1() {
        return ArchiveCache$.MODULE$.apply$default$1();
    }

    public static <F> ArchiveCache<F> apply(Sync<F> sync) {
        return ArchiveCache$.MODULE$.apply(sync);
    }

    public Iterator<Object> productIterator() {
        return Product.productIterator$((Product)this);
    }

    public File location() {
        return this.location;
    }

    public Cache<F> cache() {
        return this.cache;
    }

    public UnArchiver unArchiver() {
        return this.unArchiver;
    }

    public Sync<F> sync() {
        return this.sync;
    }

    private Sync<F> S() {
        return this.sync();
    }

    private File localDir(Artifact artifact) {
        return CachePath.localFile(artifact.url(), this.location(), (String)artifact.authentication().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.user()).orNull(Predef$.MODULE$.$conforms()), true);
    }

    public F getIfExists(Artifact artifact) {
        File dir = this.localDir(artifact);
        ArchiveType archiveType0 = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        Object dirTask = Monad$ops$.MODULE$.toAllMonadOps(this.S().delay((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> dir.exists()), this.sync()).map((Function1 & Serializable & scala.Serializable)x0$1 -> ArchiveCache.$anonfun$getIfExists$2(dir, BoxesRunTime.unboxToBoolean((Object)x0$1)));
        if (archiveType0.singleFile()) {
            return Monad$ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Right right;
                Option option;
                Either either = x0$2;
                if (either instanceof Right && (option = (Option)(right = (Right)either).value()) instanceof Some) {
                    Some some = (Some)option;
                    File dir = (File)some.value();
                    return this.S().delay((Function0 & Serializable & scala.Serializable)() -> {
                        File[] fileArray = dir.listFiles();
                        Option option = Array$.MODULE$.unapplySeq((Object)fileArray);
                        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
                            File f = (File)((SeqLike)option.get()).apply(0);
                            return package$.MODULE$.Right().apply((Object)new Some((Object)f));
                        }
                        return package$.MODULE$.Right().apply((Object)new Some((Object)dir));
                    });
                }
                return this.S().point(either);
            });
        }
        return dirTask;
    }

    public F get(Artifact artifact) {
        File dir = this.localDir(artifact);
        ArchiveType archiveType0 = ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$archiveType(artifact.url());
        Object downloadAndExtract = Monad$ops$.MODULE$.toAllMonadOps(((CacheLogger)this.cache().loggerOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> CacheLogger$.MODULE$.nop())).using().apply(this.cache().file(artifact).run(), this.sync()), this.sync()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                ArtifactError err = (ArtifactError)left.value();
                return this.S().point(package$.MODULE$.Left().apply((Object)err));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                File f = (File)right.value();
                return this.extract$1(f, false, dir, archiveType0);
            }
            throw new MatchError((Object)either);
        });
        Object dirTask = Monad$ops$.MODULE$.toAllMonadOps(this.S().delay((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> dir.exists()), this.sync()).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> ArchiveCache.$anonfun$get$7(this, artifact, dir, downloadAndExtract, archiveType0, BoxesRunTime.unboxToBoolean((Object)x0$2)));
        if (archiveType0.singleFile()) {
            return Monad$ops$.MODULE$.toAllMonadOps(dirTask, this.sync()).flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Either either = x0$4;
                if (either instanceof Right) {
                    Right right = (Right)either;
                    File dir = (File)right.value();
                    return this.S().delay((Function0 & Serializable & scala.Serializable)() -> {
                        File[] fileArray = dir.listFiles();
                        Option option = Array$.MODULE$.unapplySeq((Object)fileArray);
                        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
                            File f = (File)((SeqLike)option.get()).apply(0);
                            return package$.MODULE$.Right().apply((Object)f);
                        }
                        return package$.MODULE$.Right().apply((Object)dir);
                    });
                }
                return this.S().point(either);
            });
        }
        return dirTask;
    }

    public ArchiveCache<F> withLocation(File location) {
        return new ArchiveCache<F>(location, this.cache(), this.unArchiver(), this.sync());
    }

    public ArchiveCache<F> withCache(Cache<F> cache) {
        return new ArchiveCache<F>(this.location(), cache, this.unArchiver(), this.sync());
    }

    public ArchiveCache<F> withUnArchiver(UnArchiver unArchiver) {
        return new ArchiveCache<F>(this.location(), this.cache(), unArchiver, this.sync());
    }

    public ArchiveCache<F> withSync(Sync<F> sync) {
        return new ArchiveCache<F>(this.location(), this.cache(), this.unArchiver(), sync);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ArchiveCache(");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.cache()));
        b.append(", ");
        b.append(String.valueOf(this.unArchiver()));
        b.append(", ");
        b.append(String.valueOf(this.sync()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof ArchiveCache && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        ArchiveCache other = (ArchiveCache)obj;
        if (!true) return false;
        File file = this.location();
        File file2 = other.location();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        Cache<F> cache = this.cache();
        Cache<F> cache2 = other.cache();
        if (cache == null) {
            if (cache2 != null) {
                return false;
            }
        } else if (!cache.equals(cache2)) return false;
        UnArchiver unArchiver = this.unArchiver();
        UnArchiver unArchiver2 = other.unArchiver();
        if (unArchiver == null) {
            if (unArchiver2 != null) {
                return false;
            }
        } else if (!unArchiver.equals(unArchiver2)) return false;
        Sync<F> sync = this.sync();
        Sync<F> sync2 = other.sync();
        if (sync == null) {
            if (sync2 == null) return true;
            return false;
        } else {
            if (!sync.equals(sync2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash((Object)"ArchiveCache");
        code = 37 * code + Statics.anyHash((Object)this.location());
        code = 37 * code + Statics.anyHash(this.cache());
        code = 37 * code + Statics.anyHash((Object)this.unArchiver());
        code = 37 * code + Statics.anyHash(this.sync());
        return 37 * code;
    }

    private Tuple4<File, Cache<F>, UnArchiver, Sync<F>> tuple() {
        return new Tuple4((Object)this.location(), this.cache(), (Object)this.unArchiver(), this.sync());
    }

    public String productPrefix() {
        return "ArchiveCache";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.location();
            }
            case 1: {
                return this.cache();
            }
            case 2: {
                return this.unArchiver();
            }
            case 3: {
                return this.sync();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public static final /* synthetic */ Either $anonfun$getIfExists$2(File dir$1, boolean x0$1) {
        boolean bl = x0$1;
        if (bl) {
            return package$.MODULE$.Right().apply((Object)new Some((Object)dir$1));
        }
        if (!bl) {
            return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private static final void moveToDest$1(File tmp$1, File dir$3) {
        Files.move(tmp$1.toPath(), dir$3.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    private final Object extract$1(File f, boolean deleteDest, File dir$3, ArchiveType archiveType0$1) {
        return this.S().delay((Function0 & Serializable & scala.Serializable)() -> {
            CacheLocks$.MODULE$.withLockOr(this.location(), dir$3, (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (deleteDest || !dir$3.exists()) {
                    File tmp = CachePath.temporaryFile(dir$3);
                    ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                    Files.createDirectories(tmp.toPath(), new FileAttribute[0]);
                    this.unArchiver().extract(archiveType0$1, f, tmp, false);
                    FileTime lastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                    Files.setLastModifiedTime(tmp.toPath(), lastModifiedTime);
                    if (dir$3.exists()) {
                        if (deleteDest) {
                            ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(dir$3);
                            ArchiveCache.moveToDest$1(tmp, dir$3);
                            return;
                        }
                        ArchiveCache$.MODULE$.coursier$cache$ArchiveCache$$deleteRecursive(tmp);
                        return;
                    }
                    ArchiveCache.moveToDest$1(tmp, dir$3);
                    return;
                }
            }, (Function0 & Serializable & scala.Serializable)() -> {
                Thread.sleep(50L);
                return None$.MODULE$;
            });
            return package$.MODULE$.Right().apply((Object)dir$3);
        });
    }

    public static final /* synthetic */ Object $anonfun$get$7(ArchiveCache $this, Artifact artifact$1, File dir$3, Object downloadAndExtract$1, ArchiveType archiveType0$1, boolean x0$2) {
        boolean bl = x0$2;
        if (bl) {
            if (artifact$1.changing()) {
                return Monad$ops$.MODULE$.toAllMonadOps(((CacheLogger)$this.cache().loggerOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> CacheLogger$.MODULE$.nop())).using().apply($this.cache().file(artifact$1).run(), $this.sync()), $this.sync()).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Either either = x0$3;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        ArtifactError err = (ArtifactError)left.value();
                        return $this.S().point(package$.MODULE$.Left().apply((Object)err));
                    }
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        File f = (File)right.value();
                        FileTime archiveLastModifiedTime = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
                        FileTime dirLastModifiedTime = Files.getLastModifiedTime(dir$3.toPath(), new LinkOption[0]);
                        FileTime fileTime = archiveLastModifiedTime;
                        FileTime fileTime2 = dirLastModifiedTime;
                        if (!(fileTime != null ? !((Object)fileTime).equals(fileTime2) : fileTime2 != null)) {
                            return $this.S().point(package$.MODULE$.Right().apply((Object)dir$3));
                        }
                        return $this.extract$1(f, true, dir$3, archiveType0$1);
                    }
                    throw new MatchError((Object)either);
                });
            }
            return $this.S().point(package$.MODULE$.Right().apply((Object)dir$3));
        }
        if (!bl) {
            return downloadAndExtract$1;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public ArchiveCache(File location, Cache<F> cache, UnArchiver unArchiver, Sync<F> sync) {
        this.location = location;
        this.cache = cache;
        this.unArchiver = unArchiver;
        this.sync = sync;
        Product.$init$((Product)this);
    }

    public ArchiveCache(File location, Sync<F> sync) {
        this(location, FileCache$.MODULE$.apply(sync), UnArchiver$.MODULE$.default(), sync);
    }
}

