/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.proxy;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import javax.annotation.Nonnull;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.filemappers.FileMapper;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.fileselectors.FileSelector;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.functions.NameSupplier;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.functions.ResourceAttributeSupplier;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollection;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollectionWithAttributes;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.EncodingSupported;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.PlexusIoResource;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.Stream;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.proxy.ForwardingIterator;
import lmcoursier.internal.shaded.org.codehaus.plexus.components.io.resources.proxy.ProxyFactory;

public class PlexusIoProxyResourceCollection
extends AbstractPlexusIoResourceCollectionWithAttributes
implements EncodingSupported {
    private PlexusIoResourceCollection src;

    public PlexusIoProxyResourceCollection(@Nonnull PlexusIoResourceCollection src) {
        this.src = src;
    }

    public PlexusIoResourceCollection getSrc() {
        return this.src;
    }

    public void setDefaultAttributes(int uid, String userName, int gid, String groupName, int fileMode, int dirMode) {
        this.setDefaultFileAttributes(new SimpleResourceAttributes(uid, userName, gid, groupName, fileMode));
        this.setDefaultDirAttributes(new SimpleResourceAttributes(uid, userName, gid, groupName, dirMode));
    }

    public void setOverrideAttributes(int uid, String userName, int gid, String groupName, int fileMode, int dirMode) {
        this.setOverrideFileAttributes(new SimpleResourceAttributes(uid, userName, gid, groupName, fileMode));
        this.setOverrideDirAttributes(new SimpleResourceAttributes(uid, userName, gid, groupName, dirMode));
    }

    @Override
    public void setStreamTransformer(InputStreamTransformer streamTransformer) {
        if (this.src instanceof AbstractPlexusIoResourceCollection) {
            ((AbstractPlexusIoResourceCollection)this.src).setStreamTransformer(streamTransformer);
        }
        super.setStreamTransformer(streamTransformer);
    }

    protected FileSelector getDefaultFileSelector() {
        IncludeExcludeFileSelector fileSelector = new IncludeExcludeFileSelector();
        fileSelector.setIncludes(this.getIncludes());
        fileSelector.setExcludes(this.getExcludes());
        fileSelector.setCaseSensitive(this.isCaseSensitive());
        fileSelector.setUseDefaultExcludes(this.isUsingDefaultExcludes());
        return fileSelector;
    }

    private String getNonEmptyPrfix() {
        String prefix = this.getPrefix();
        if (prefix != null && prefix.length() == 0) {
            return null;
        }
        return prefix;
    }

    @Override
    public Stream stream() {
        return this.getSrc().stream();
    }

    @Override
    public Iterator<PlexusIoResource> getResources() throws IOException {
        return new FwdIterator(this.getSrc().getResources());
    }

    @Override
    public String getName(PlexusIoResource resource) {
        String name = resource.getName();
        FileMapper[] mappers = this.getFileMappers();
        if (mappers != null) {
            for (FileMapper mapper : mappers) {
                name = mapper.getMappedFileName(name);
            }
        }
        return name;
    }

    @Override
    public long getLastModified() throws IOException {
        return this.src.getLastModified();
    }

    @Override
    public void setEncoding(Charset charset) {
        if (this.src instanceof EncodingSupported) {
            ((EncodingSupported)((Object)this.src)).setEncoding(charset);
        }
    }

    @Override
    public boolean isConcurrentAccessSupported() {
        return this.src.isConcurrentAccessSupported();
    }

    static abstract class DualSupplier
    implements NameSupplier,
    ResourceAttributeSupplier {
        DualSupplier() {
        }
    }

    class FwdIterator
    extends ForwardingIterator {
        Iterator<PlexusIoResource> iter;
        private final FileSelector fileSelector;
        private final String prefix;

        FwdIterator(Iterator<PlexusIoResource> resources) {
            super(resources);
            this.fileSelector = PlexusIoProxyResourceCollection.this.getDefaultFileSelector();
            this.prefix = PlexusIoProxyResourceCollection.this.getNonEmptyPrfix();
            this.iter = resources;
        }

        @Override
        protected PlexusIoResource getNextResource() throws IOException {
            if (!this.iter.hasNext()) {
                return null;
            }
            PlexusIoResource plexusIoResource = this.iter.next();
            while (!this.fileSelector.isSelected(plexusIoResource) || !PlexusIoProxyResourceCollection.this.isSelected(plexusIoResource) || plexusIoResource.isDirectory() && !PlexusIoProxyResourceCollection.this.isIncludingEmptyDirectories()) {
                if (!this.iter.hasNext()) {
                    return null;
                }
                plexusIoResource = this.iter.next();
            }
            PlexusIoResourceAttributes attrs = null;
            if (plexusIoResource instanceof ResourceAttributeSupplier) {
                attrs = ((ResourceAttributeSupplier)((Object)plexusIoResource)).getAttributes();
            }
            if (attrs == null) {
                attrs = SimpleResourceAttributes.lastResortDummyAttributesForBrokenOS();
            }
            attrs = PlexusIoProxyResourceCollection.this.mergeAttributes(attrs, plexusIoResource.isDirectory());
            if (this.prefix != null) {
                final String name = plexusIoResource.getName();
                final PlexusIoResourceAttributes attrs2 = attrs;
                DualSupplier supplier = new DualSupplier(){

                    @Override
                    public String getName() {
                        return FwdIterator.this.prefix + name;
                    }

                    @Override
                    public PlexusIoResourceAttributes getAttributes() {
                        return attrs2;
                    }
                };
                plexusIoResource = ProxyFactory.createProxy(plexusIoResource, supplier);
            }
            return plexusIoResource;
        }
    }
}

