/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.codehaus.plexus.classworlds.launcher;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import lmcoursier.internal.shaded.org.codehaus.plexus.classworlds.ClassWorld;
import lmcoursier.internal.shaded.org.codehaus.plexus.classworlds.launcher.ConfigurationException;
import lmcoursier.internal.shaded.org.codehaus.plexus.classworlds.launcher.ConfigurationHandler;
import lmcoursier.internal.shaded.org.codehaus.plexus.classworlds.launcher.ConfigurationParser;
import lmcoursier.internal.shaded.org.codehaus.plexus.classworlds.launcher.Launcher;
import lmcoursier.internal.shaded.org.codehaus.plexus.classworlds.realm.ClassRealm;
import lmcoursier.internal.shaded.org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import lmcoursier.internal.shaded.org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

public class Configurator
implements ConfigurationHandler {
    private Launcher launcher;
    private ClassWorld world;
    private Map<String, ClassRealm> configuredRealms;
    private ClassRealm curRealm;
    private ClassLoader foreignClassLoader = null;

    public Configurator(Launcher launcher) {
        this.launcher = launcher;
        this.configuredRealms = new HashMap<String, ClassRealm>();
        if (launcher != null) {
            this.foreignClassLoader = launcher.getSystemClassLoader();
        }
    }

    public Configurator(ClassWorld world) {
        this.setClassWorld(world);
    }

    public void setClassWorld(ClassWorld world) {
        this.world = world;
        this.configuredRealms = new HashMap<String, ClassRealm>();
    }

    public void configure(InputStream is) throws IOException, ConfigurationException, DuplicateRealmException, NoSuchRealmException {
        if (this.world == null) {
            this.world = new ClassWorld();
        }
        this.curRealm = null;
        this.foreignClassLoader = null;
        if (this.launcher != null) {
            this.foreignClassLoader = this.launcher.getSystemClassLoader();
        }
        ConfigurationParser parser = new ConfigurationParser(this, System.getProperties());
        parser.parse(is);
        this.associateRealms();
        if (this.launcher != null) {
            this.launcher.setWorld(this.world);
        }
    }

    public void associateRealms() {
        ArrayList<String> sortRealmNames = new ArrayList<String>(this.configuredRealms.keySet());
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String g1, String g2) {
                return g1.compareTo(g2);
            }
        };
        Collections.sort(sortRealmNames, comparator);
        for (String realmName : sortRealmNames) {
            String parentRealmName;
            ClassRealm parentRealm;
            int j = realmName.lastIndexOf(46);
            if (j <= 0 || (parentRealm = this.configuredRealms.get(parentRealmName = realmName.substring(0, j))) == null) continue;
            ClassRealm realm2 = this.configuredRealms.get(realmName);
            realm2.setParentRealm(parentRealm);
        }
    }

    @Override
    public void addImportFrom(String relamName, String importSpec) throws NoSuchRealmException {
        this.curRealm.importFrom(relamName, importSpec);
    }

    @Override
    public void addLoadFile(File file) {
        try {
            this.curRealm.addURL(file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public void addLoadURL(URL url) {
        this.curRealm.addURL(url);
    }

    @Override
    public void addRealm(String realmName) throws DuplicateRealmException {
        this.curRealm = this.world.newRealm(realmName, this.foreignClassLoader);
        this.configuredRealms.put(realmName, this.curRealm);
    }

    @Override
    public void setAppMain(String mainClassName, String mainRealmName) {
        if (this.launcher != null) {
            this.launcher.setAppMain(mainClassName, mainRealmName);
        }
    }
}

