/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.org.apache.xbean.propertyeditor;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ReferenceIdentityMap
implements Map {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private float loadFactor = 0.75f;
    private transient int size;
    private transient ReferenceEntry[] data = new ReferenceEntry[16];
    private transient int threshold = this.calculateThreshold(16, this.loadFactor);
    private ReferenceQueue purgeQueue = new ReferenceQueue();

    public int size() {
        this.purge();
        return this.size;
    }

    public boolean isEmpty() {
        this.purge();
        return this.size == 0;
    }

    public boolean containsKey(Object key) {
        this.purge();
        ReferenceEntry entry = this.getEntry(key);
        if (entry == null) {
            return false;
        }
        return entry.getValue() != null;
    }

    public boolean containsValue(Object value) {
        this.purge();
        if (value == null || this.size == 0) {
            return false;
        }
        ReferenceEntry[] table = this.data;
        for (int i = 0; i < table.length; ++i) {
            ReferenceEntry entry = table[i];
            while (entry != null) {
                if (value.equals(entry.getValue())) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public Object get(Object key) {
        this.purge();
        ReferenceEntry entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Object put(Object key, Object value) {
        assert (key != null) : "key is null";
        assert (value != null) : "value is null";
        this.purge();
        int hashCode = this.hash(key);
        int index = this.hashIndex(hashCode, this.data.length);
        ReferenceEntry entry = this.data[index];
        while (entry != null) {
            if (entry.hashCode == hashCode && key == entry.getKey()) {
                return entry.setValue(value);
            }
            entry = entry.next;
        }
        this.createEntry(index, hashCode, key, value);
        return null;
    }

    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        this.purge();
        int hashCode = this.hash(key);
        int index = this.hashIndex(hashCode, this.data.length);
        ReferenceEntry entry = this.data[index];
        ReferenceEntry previous = null;
        while (entry != null) {
            if (entry.hashCode == hashCode && key == entry.getKey()) {
                Object oldValue = entry.getValue();
                this.removeEntry(entry, index, previous);
                return oldValue;
            }
            previous = entry;
            entry = entry.next;
        }
        return null;
    }

    public void clear() {
        ReferenceEntry[] data = this.data;
        for (int i = data.length - 1; i >= 0; --i) {
            data[i] = null;
        }
        this.size = 0;
        while (this.purgeQueue.poll() != null) {
        }
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    private ReferenceEntry getEntry(Object key) {
        if (key == null) {
            return null;
        }
        int hashCode = this.hash(key);
        ReferenceEntry entry = this.data[this.hashIndex(hashCode, this.data.length)];
        while (entry != null) {
            if (entry.hashCode == hashCode && key == entry.getKey()) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    private ReferenceEntry createEntry(int index, int hashCode, Object key, Object value) {
        ReferenceEntry newEntry;
        this.data[index] = newEntry = new ReferenceEntry(this, this.data[index], hashCode, key, value);
        ++this.size;
        this.checkCapacity();
        return newEntry;
    }

    private void removeEntry(ReferenceEntry entry, int hashIndex, ReferenceEntry previous) {
        if (previous == null) {
            this.data[hashIndex] = entry.next;
        } else {
            previous.next = entry.next;
        }
        --this.size;
        entry.next = null;
        entry.clear();
        entry.value = null;
    }

    private void checkCapacity() {
        int newCapacity;
        if (this.size >= this.threshold && (newCapacity = this.data.length * 2) <= 0x40000000) {
            this.ensureCapacity(newCapacity);
        }
    }

    private void ensureCapacity(int newCapacity) {
        int oldCapacity = this.data.length;
        if (newCapacity <= oldCapacity) {
            return;
        }
        ReferenceEntry[] oldEntries = this.data;
        ReferenceEntry[] newEntries = new ReferenceEntry[newCapacity];
        for (int i = oldCapacity - 1; i >= 0; --i) {
            ReferenceEntry next;
            ReferenceEntry entry = oldEntries[i];
            if (entry == null) continue;
            oldEntries[i] = null;
            do {
                next = entry.next;
                int index = this.hashIndex(entry.hashCode, newCapacity);
                entry.next = newEntries[index];
                newEntries[index] = entry;
            } while ((entry = next) != null);
        }
        this.threshold = this.calculateThreshold(newCapacity, this.loadFactor);
        this.data = newEntries;
    }

    private int calculateThreshold(int newCapacity, float factor) {
        return (int)((float)newCapacity * factor);
    }

    private int hash(Object key) {
        return System.identityHashCode(key);
    }

    private int hashIndex(int hashCode, int dataSize) {
        return hashCode & dataSize - 1;
    }

    private void purge() {
        Reference entryRef = this.purgeQueue.poll();
        while (entryRef != null) {
            this.purge(entryRef);
            entryRef = this.purgeQueue.poll();
        }
    }

    private void purge(Reference purgedEntry) {
        int hash = ((ReferenceEntry)purgedEntry).hashCode;
        int index = this.hashIndex(hash, this.data.length);
        ReferenceEntry previous = null;
        ReferenceEntry currentEntry = this.data[index];
        while (currentEntry != null) {
            if (currentEntry == purgedEntry) {
                currentEntry.purged();
                if (previous == null) {
                    this.data[index] = currentEntry.next;
                } else {
                    previous.next = currentEntry.next;
                }
                --this.size;
                return;
            }
            previous = currentEntry;
            currentEntry = currentEntry.next;
        }
    }

    private static class ReferenceEntry
    extends WeakReference {
        private ReferenceEntry next;
        private int hashCode;
        private Object value;

        private ReferenceEntry(ReferenceIdentityMap parent, ReferenceEntry next, int hashCode, Object key, Object value) {
            super(key, parent.purgeQueue);
            this.next = next;
            this.hashCode = hashCode;
            this.value = value;
        }

        private Object getKey() {
            return this.get();
        }

        private Object getValue() {
            return this.value;
        }

        private Object setValue(Object obj) {
            Object old = this.getValue();
            this.value = obj;
            return old;
        }

        private void purged() {
            this.clear();
            this.value = null;
        }
    }
}

