/*
 * Decompiled with CFR 0.152.
 */
package lmcoursier.internal.shaded.coursier.paths;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import lmcoursier.internal.shaded.coursier.cache.shaded.io.github.soc.directories.ProjectDirectories;

public final class CoursierPaths {
    private static ProjectDirectories coursierDirectories;
    private static volatile File cacheDirectory0;
    private static final Object lock;

    private CoursierPaths() {
        throw new Error();
    }

    private static File computeCacheDirectory() throws IOException {
        File file2;
        String string = System.getenv("COURSIER_CACHE");
        if (string == null) {
            string = System.getProperty("lmcoursier.internal.shaded.coursier.cache");
        }
        File file3 = new File(CoursierPaths.coursierDirectories.cacheDir);
        File file4 = new File(file3, "v1");
        String string2 = file4.getAbsolutePath();
        if (string == null && file3.isDirectory()) {
            string = string2;
        }
        if (string == null && (file2 = new File(System.getProperty("user.home") + "/.coursier")).isDirectory()) {
            string = System.getProperty("user.home") + "/.coursier/cache/v1/";
        }
        if (string == null) {
            string = string2;
            Files.createDirectories(file4.toPath(), new FileAttribute[0]);
        }
        return new File(string).getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() throws IOException {
        if (cacheDirectory0 == null) {
            Object object = lock;
            synchronized (object) {
                if (cacheDirectory0 == null) {
                    coursierDirectories = ProjectDirectories.from(null, null, "Coursier");
                    cacheDirectory0 = CoursierPaths.computeCacheDirectory();
                }
            }
        }
    }

    public static File cacheDirectory() throws IOException {
        CoursierPaths.init();
        return cacheDirectory0;
    }

    public static File configDirectory() throws IOException {
        CoursierPaths.init();
        return new File(CoursierPaths.coursierDirectories.configDir);
    }

    public static File dataLocalDirectory() throws IOException {
        CoursierPaths.init();
        return new File(CoursierPaths.coursierDirectories.dataLocalDir);
    }

    static {
        cacheDirectory0 = null;
        lock = new Object();
    }
}

