/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection.immutable;

import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.PartialFunction;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.IterableOnceOps;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.SortedSet;
import coursierapi.shaded.scala.collection.SortedSetFactoryDefaults;
import coursierapi.shaded.scala.collection.SortedSetOps;
import coursierapi.shaded.scala.collection.StrictOptimizedIterableOps;
import coursierapi.shaded.scala.collection.generic.DefaultSerializable;
import coursierapi.shaded.scala.collection.immutable.AbstractSet;
import coursierapi.shaded.scala.collection.immutable.RedBlackTree;
import coursierapi.shaded.scala.collection.immutable.RedBlackTree$;
import coursierapi.shaded.scala.collection.immutable.Set;
import coursierapi.shaded.scala.collection.immutable.SetOps;
import coursierapi.shaded.scala.collection.immutable.StrictOptimizedSortedSetOps;
import coursierapi.shaded.scala.collection.immutable.TreeSet$;
import coursierapi.shaded.scala.collection.mutable.Builder;
import coursierapi.shaded.scala.math.Ordering;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Nothing$;

public final class TreeSet<A>
extends AbstractSet<A>
implements DefaultSerializable,
coursierapi.shaded.scala.collection.immutable.SortedSet<A>,
StrictOptimizedSortedSetOps<A, TreeSet, TreeSet<A>> {
    private final RedBlackTree.Tree<A, Object> tree;
    private final Ordering<A> ordering;

    @Override
    public <A1, A2> Tuple2<Set<A1>, Set<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public /* synthetic */ boolean scala$collection$SortedSet$$super$equals(Object that) {
        return coursierapi.shaded.scala.collection.Set.equals$(this, that);
    }

    @Override
    public String stringPrefix() {
        return SortedSet.stringPrefix$(this);
    }

    @Override
    public SortedSet fromSpecific(IterableOnce coll) {
        return SortedSetFactoryDefaults.fromSpecific$(this, coll);
    }

    @Override
    public Builder<A, TreeSet<A>> newSpecificBuilder() {
        return SortedSetFactoryDefaults.newSpecificBuilder$(this);
    }

    @Override
    public SortedSet empty() {
        return SortedSetFactoryDefaults.empty$(this);
    }

    @Override
    public SortedSetOps.WithFilter<A, ?, ?> withFilter(Function1<A, Object> p) {
        return SortedSetFactoryDefaults.withFilter$(this, p);
    }

    @Override
    public /* synthetic */ Object scala$collection$SortedSetOps$$super$min(Ordering ord) {
        return IterableOnceOps.min$(this, ord);
    }

    @Override
    public /* synthetic */ Object scala$collection$SortedSetOps$$super$max(Ordering ord) {
        return IterableOnceOps.max$(this, ord);
    }

    @Override
    public A firstKey() {
        return (A)SortedSetOps.firstKey$(this);
    }

    @Override
    public A lastKey() {
        return (A)SortedSetOps.lastKey$(this);
    }

    public RedBlackTree.Tree<A, Object> tree() {
        return this.tree;
    }

    @Override
    public Ordering<A> ordering() {
        return this.ordering;
    }

    public TreeSet$ sortedIterableFactory() {
        return TreeSet$.MODULE$;
    }

    private TreeSet<A> newSetOrSelf(RedBlackTree.Tree<A, Object> t) {
        if (t == this.tree()) {
            return this;
        }
        return new TreeSet<A>(t, this.ordering());
    }

    @Override
    public int size() {
        return RedBlackTree$.MODULE$.count(this.tree());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public A head() {
        return RedBlackTree$.MODULE$.smallest(this.tree()).key();
    }

    @Override
    public A last() {
        return RedBlackTree$.MODULE$.greatest(this.tree()).key();
    }

    @Override
    public TreeSet<A> tail() {
        return new TreeSet<A>(RedBlackTree$.MODULE$.tail(this.tree()), this.ordering());
    }

    @Override
    public <A1> A min(Ordering<A1> ord) {
        if (ord == this.ordering() && IterableOnceOps.nonEmpty$(this)) {
            return this.head();
        }
        return (A)SortedSetOps.min$(this, ord);
    }

    @Override
    public <A1> A max(Ordering<A1> ord) {
        if (ord == this.ordering() && IterableOnceOps.nonEmpty$(this)) {
            return this.last();
        }
        return (A)SortedSetOps.max$(this, ord);
    }

    @Override
    public TreeSet<A> drop(int n) {
        if (n <= 0) {
            return this;
        }
        if (n >= this.size()) {
            return (TreeSet)SortedSetFactoryDefaults.empty$(this);
        }
        return new TreeSet<A>(RedBlackTree$.MODULE$.drop(this.tree(), n, this.ordering()), this.ordering());
    }

    @Override
    public TreeSet<A> take(int n) {
        if (n <= 0) {
            return (TreeSet)SortedSetFactoryDefaults.empty$(this);
        }
        if (n >= this.size()) {
            return this;
        }
        return new TreeSet<A>(RedBlackTree$.MODULE$.take(this.tree(), n, this.ordering()), this.ordering());
    }

    @Override
    public TreeSet<A> slice(int from, int until) {
        if (until <= from) {
            return (TreeSet)SortedSetFactoryDefaults.empty$(this);
        }
        if (from <= 0) {
            return this.take(until);
        }
        if (until >= this.size()) {
            return this.drop(from);
        }
        return new TreeSet<A>(RedBlackTree$.MODULE$.slice(this.tree(), from, until, this.ordering()), this.ordering());
    }

    @Override
    public TreeSet<A> takeRight(int n) {
        int max_y = 0;
        return this.drop(this.size() - Math.max(n, max_y));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TreeSet<A> dropWhile(Function1<A, Object> p) {
        void var2_2;
        int countWhile_result = 0;
        Iterator<A> countWhile_it = this.iterator();
        while (countWhile_it.hasNext() && BoxesRunTime.unboxToBoolean(p.apply(countWhile_it.next()))) {
            ++countWhile_result;
        }
        Object var3_3 = null;
        return this.drop((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TreeSet<A> takeWhile(Function1<A, Object> p) {
        void var2_2;
        int countWhile_result = 0;
        Iterator<A> countWhile_it = this.iterator();
        while (countWhile_it.hasNext() && BoxesRunTime.unboxToBoolean(p.apply(countWhile_it.next()))) {
            ++countWhile_result;
        }
        Object var3_3 = null;
        return this.take((int)var2_2);
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        RedBlackTree$.MODULE$.foreachKey(this.tree(), f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<A> iterator() {
        void keysIterator_evidence$17;
        Ordering<A> ordering = this.ordering();
        None$ keysIterator_start = None$.MODULE$;
        RedBlackTree.Tree<A, Object> keysIterator_tree = this.tree();
        return new RedBlackTree.KeysIterator<Nothing$, Object>((RedBlackTree.Tree<Nothing$, Object>)keysIterator_tree, keysIterator_start, (Ordering<Nothing$>)keysIterator_evidence$17);
    }

    @Override
    public boolean contains(A elem) {
        return RedBlackTree$.MODULE$.contains(this.tree(), elem, this.ordering());
    }

    @Override
    public TreeSet<A> incl(A elem) {
        return this.newSetOrSelf(RedBlackTree$.MODULE$.update(this.tree(), elem, null, false, this.ordering()));
    }

    @Override
    public TreeSet<A> excl(A elem) {
        return this.newSetOrSelf(RedBlackTree$.MODULE$.delete(this.tree(), elem, this.ordering()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public TreeSet<A> concat(IterableOnce<A> that) {
        RedBlackTree.Tree<A, Object> tree;
        if (that instanceof TreeSet) {
            TreeSet treeSet = (TreeSet)that;
            Ordering<A> ordering = this.ordering();
            Ordering<A> ordering2 = treeSet.ordering();
            if (!(ordering != null ? !ordering.equals(ordering2) : ordering2 != null)) {
                tree = RedBlackTree$.MODULE$.union(this.tree(), treeSet.tree(), this.ordering());
                return this.newSetOrSelf(tree);
            }
        }
        Iterator<A> it = that.iterator();
        RedBlackTree.Tree<A, Object> t = this.tree();
        while (true) {
            if (!it.hasNext()) {
                tree = t;
                return this.newSetOrSelf(tree);
            }
            t = RedBlackTree$.MODULE$.update(t, it.next(), null, false, this.ordering());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TreeSet<A> removedAll(IterableOnce<A> that) {
        if (!(that instanceof TreeSet)) return (TreeSet<A>)SetOps.removedAll$(this, that);
        TreeSet treeSet = (TreeSet)that;
        Ordering<A> ordering = this.ordering();
        Ordering<A> ordering2 = treeSet.ordering();
        if (ordering != null) {
            if (!ordering.equals(ordering2)) return (TreeSet<A>)SetOps.removedAll$(this, that);
            return this.newSetOrSelf(RedBlackTree$.MODULE$.difference(this.tree(), treeSet.tree(), this.ordering()));
        }
        if (ordering2 == null) return this.newSetOrSelf(RedBlackTree$.MODULE$.difference(this.tree(), treeSet.tree(), this.ordering()));
        return (TreeSet<A>)SetOps.removedAll$(this, that);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TreeSet<A> intersect(coursierapi.shaded.scala.collection.Set<A> that) {
        if (!(that instanceof TreeSet)) return this.newSetOrSelf(RedBlackTree$.MODULE$.filterKeys(this.tree(), that));
        TreeSet treeSet = (TreeSet)that;
        Ordering<A> ordering = this.ordering();
        Ordering<A> ordering2 = treeSet.ordering();
        if (ordering != null) {
            if (!ordering.equals(ordering2)) return this.newSetOrSelf(RedBlackTree$.MODULE$.filterKeys(this.tree(), that));
            return this.newSetOrSelf(RedBlackTree$.MODULE$.intersect(this.tree(), treeSet.tree(), this.ordering()));
        }
        if (ordering2 == null) return this.newSetOrSelf(RedBlackTree$.MODULE$.intersect(this.tree(), treeSet.tree(), this.ordering()));
        return this.newSetOrSelf(RedBlackTree$.MODULE$.filterKeys(this.tree(), that));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TreeSet<A> diff(coursierapi.shaded.scala.collection.Set<A> that) {
        if (!(that instanceof TreeSet)) return (TreeSet<A>)SetOps.diff$(this, that);
        TreeSet treeSet = (TreeSet)that;
        Ordering<A> ordering = this.ordering();
        Ordering<A> ordering2 = treeSet.ordering();
        if (ordering != null) {
            if (!ordering.equals(ordering2)) return (TreeSet<A>)SetOps.diff$(this, that);
            return this.newSetOrSelf(RedBlackTree$.MODULE$.difference(this.tree(), treeSet.tree(), this.ordering()));
        }
        if (ordering2 == null) return this.newSetOrSelf(RedBlackTree$.MODULE$.difference(this.tree(), treeSet.tree(), this.ordering()));
        return (TreeSet<A>)SetOps.diff$(this, that);
    }

    @Override
    public TreeSet<A> filter(Function1<A, Object> f) {
        return this.newSetOrSelf(RedBlackTree$.MODULE$.filterKeys(this.tree(), f));
    }

    @Override
    public Tuple2<TreeSet<A>, TreeSet<A>> partition(Function1<A, Object> p) {
        Tuple2<RedBlackTree.Tree<A, Object>, RedBlackTree.Tree<A, Object>> tuple2 = RedBlackTree$.MODULE$.partitionKeys(this.tree(), p);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        RedBlackTree.Tree<A, Object> tree = tuple2._1();
        RedBlackTree.Tree<A, Object> tree2 = tuple2._2();
        return new Tuple2<TreeSet<A>, TreeSet<A>>(this.newSetOrSelf(tree), this.newSetOrSelf(tree2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TreeSet)) return SortedSet.equals$(this, obj);
        TreeSet treeSet = (TreeSet)obj;
        Ordering<A> ordering = this.ordering();
        Ordering<A> ordering2 = treeSet.ordering();
        if (ordering != null) {
            if (!ordering.equals(ordering2)) return SortedSet.equals$(this, obj);
            return RedBlackTree$.MODULE$.keysEqual(this.tree(), treeSet.tree(), this.ordering());
        }
        if (ordering2 == null) return RedBlackTree$.MODULE$.keysEqual(this.tree(), treeSet.tree(), this.ordering());
        return SortedSet.equals$(this, obj);
    }

    @Override
    public String className() {
        return "TreeSet";
    }

    public TreeSet(RedBlackTree.Tree<A, Object> tree, Ordering<A> ordering) {
        this.tree = tree;
        this.ordering = ordering;
        if (ordering == null) {
            throw new NullPointerException("ordering must not be null");
        }
    }

    public TreeSet(Ordering<A> ordering) {
        this(null, ordering);
    }
}

