/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection;

import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.PartialFunction;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.AbstractIterator;
import coursierapi.shaded.scala.collection.AbstractView;
import coursierapi.shaded.scala.collection.Iterable;
import coursierapi.shaded.scala.collection.IterableFactory;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.IterableOps;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.Iterator$;
import coursierapi.shaded.scala.collection.View$;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.collection.mutable.ArrayBuffer;
import java.io.Serializable;

public interface View<A>
extends Serializable,
Iterable<A> {
    public static /* synthetic */ View view$(View $this) {
        return $this.view();
    }

    @Override
    default public View<A> view() {
        return this;
    }

    public static /* synthetic */ IterableFactory iterableFactory$(View $this) {
        return $this.iterableFactory();
    }

    @Override
    default public IterableFactory<View> iterableFactory() {
        return View$.MODULE$;
    }

    public static /* synthetic */ View empty$(View $this) {
        return $this.empty();
    }

    @Override
    default public View<A> empty() {
        return this.iterableFactory().empty();
    }

    public static /* synthetic */ String toString$(View $this) {
        return $this.toString();
    }

    @Override
    default public String toString() {
        return new StringBuilder(16).append(this.className()).append("(<not computed>)").toString();
    }

    public static /* synthetic */ String stringPrefix$(View $this) {
        return $this.stringPrefix();
    }

    @Override
    default public String stringPrefix() {
        return "View";
    }

    public static class Appended<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final A elem;

        @Override
        public Iterator<A> iterator() {
            return new Concat<A>(this.underlying, new Single<A>(this.elem)).iterator();
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                return size + 1;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public Appended(IterableOps<A, ?, Object> underlying, A elem) {
            this.underlying = underlying;
            this.elem = elem;
        }
    }

    public static class Collect<A, B>
    extends AbstractView<B> {
        private final IterableOps<A, ?, Object> underlying;
        private final PartialFunction<A, B> pf;

        @Override
        public Iterator<B> iterator() {
            return this.underlying.iterator().collect(this.pf);
        }

        public Collect(IterableOps<A, ?, Object> underlying, PartialFunction<A, B> pf) {
            this.underlying = underlying;
            this.pf = pf;
        }
    }

    public static class Concat<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> prefix;
        private final IterableOps<A, ?, Object> suffix;

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterator<A> iterator() {
            void $plus$plus_xs;
            Iterator iterator = this.prefix.iterator();
            Function0<Iterator> & Serializable intersect = (Function0<Iterator> & Serializable)() -> $this.suffix.iterator();
            if (iterator == null) {
                throw null;
            }
            return iterator.concat($plus$plus_xs);
        }

        @Override
        public int knownSize() {
            int prefixSize = this.prefix.knownSize();
            if (prefixSize >= 0) {
                int suffixSize = this.suffix.knownSize();
                if (suffixSize >= 0) {
                    return prefixSize + suffixSize;
                }
                return -1;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.prefix.isEmpty() && this.suffix.isEmpty();
        }

        public Concat(IterableOps<A, ?, Object> prefix, IterableOps<A, ?, Object> suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }
    }

    public static class DistinctBy<A, B>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, B> f;

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().distinctBy(this.f);
        }

        @Override
        public int knownSize() {
            if (this.underlying.knownSize() == 0) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        public DistinctBy(IterableOps<A, ?, Object> underlying, Function1<A, B> f) {
            this.underlying = underlying;
            this.f = f;
        }
    }

    public static class Drop<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final int n;
        private final int normN;

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().drop(this.n);
        }

        public int normN() {
            return this.normN;
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                int n = size - this.normN();
                int max$extension_that = 0;
                return Math.max(n, max$extension_that);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        public Drop(IterableOps<A, ?, Object> underlying, int n) {
            this.underlying = underlying;
            this.n = n;
            int max$extension_that = 0;
            this.normN = Math.max(n, max$extension_that);
        }
    }

    public static class DropWhile<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, Object> p;

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().dropWhile(this.p);
        }

        @Override
        public int knownSize() {
            if (this.underlying.knownSize() == 0) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        public DropWhile(IterableOps<A, ?, Object> underlying, Function1<A, Object> p) {
            this.underlying = underlying;
            this.p = p;
        }
    }

    public static class Elems<A>
    extends AbstractView<A> {
        private final Seq<A> xs;

        @Override
        public Iterator<A> iterator() {
            return this.xs.iterator();
        }

        @Override
        public int knownSize() {
            return this.xs.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.xs.isEmpty();
        }

        public Elems(Seq<A> xs) {
            this.xs = xs;
        }
    }

    public static class Fill<A>
    extends AbstractView<A> {
        private final int n;
        private final Function0<A> elem;

        @Override
        public Iterator<A> iterator() {
            Function0<A> fill_elem = this.elem;
            int fill_len = this.n;
            return new AbstractIterator<A>(fill_len, fill_elem){
                private int i;
                private final int len$3;
                private final Function0 elem$4;

                public int knownSize() {
                    int n = this.len$3 - this.i;
                    int max$extension_that = 0;
                    return Math.max(n, max$extension_that);
                }

                public boolean hasNext() {
                    return this.i < this.len$3;
                }

                public A next() {
                    if (this.hasNext()) {
                        ++this.i;
                        return (A)this.elem$4.apply();
                    }
                    return (A)Iterator$.scala$collection$Iterator$$_empty.next();
                }
                {
                    this.len$3 = len$3;
                    this.elem$4 = elem$4;
                    this.i = 0;
                }
            };
        }

        @Override
        public int knownSize() {
            int n = 0;
            int max$extension_that = this.n;
            return Math.max(n, max$extension_that);
        }

        @Override
        public boolean isEmpty() {
            return this.n <= 0;
        }

        public Fill(int n, Function0<A> elem) {
            this.n = n;
            this.elem = elem;
        }
    }

    public static class Filter<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, Object> p;
        private final boolean isFlipped;

        public IterableOps<A, ?, Object> underlying() {
            return this.underlying;
        }

        public Function1<A, Object> p() {
            return this.p;
        }

        public boolean isFlipped() {
            return this.isFlipped;
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying().iterator().filterImpl(this.p(), this.isFlipped());
        }

        @Override
        public int knownSize() {
            if (this.underlying().knownSize() == 0) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        public Filter(IterableOps<A, ?, Object> underlying, Function1<A, Object> p, boolean isFlipped) {
            this.underlying = underlying;
            this.p = p;
            this.isFlipped = isFlipped;
        }
    }

    public static class FlatMap<A, B>
    extends AbstractView<B> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, IterableOnce<B>> f;

        @Override
        public Iterator<B> iterator() {
            return this.underlying.iterator().flatMap(this.f);
        }

        @Override
        public int knownSize() {
            if (this.underlying.knownSize() == 0) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        public FlatMap(IterableOps<A, ?, Object> underlying, Function1<A, IterableOnce<B>> f) {
            this.underlying = underlying;
            this.f = f;
        }
    }

    public static class Map<A, B>
    extends AbstractView<B> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, B> f;

        @Override
        public Iterator<B> iterator() {
            return this.underlying.iterator().map(this.f);
        }

        @Override
        public int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        public Map(IterableOps<A, ?, Object> underlying, Function1<A, B> f) {
            this.underlying = underlying;
            this.f = f;
        }
    }

    public static class Prepended<A>
    extends AbstractView<A> {
        private final A elem;
        private final IterableOps<A, ?, Object> underlying;

        @Override
        public Iterator<A> iterator() {
            return new Concat<A>(new Single<A>(this.elem), this.underlying).iterator();
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                return size + 1;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public Prepended(A elem, IterableOps<A, ?, Object> underlying) {
            this.elem = elem;
            this.underlying = underlying;
        }
    }

    public static class Single<A>
    extends AbstractView<A> {
        private final A a;

        @Override
        public Iterator<A> iterator() {
            A single_a = this.a;
            return new AbstractIterator<A>(single_a){
                private boolean consumed;
                private final Object a$1;

                public boolean hasNext() {
                    return !this.consumed;
                }

                public A next() {
                    if (this.consumed) {
                        return (A)Iterator$.scala$collection$Iterator$$_empty.next();
                    }
                    this.consumed = true;
                    return (A)this.a$1;
                }
                {
                    this.a$1 = a$1;
                    this.consumed = false;
                }
            };
        }

        @Override
        public int knownSize() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public Single(A a) {
            this.a = a;
        }
    }

    public static class Tabulate<A>
    extends AbstractView<A> {
        private final int n;
        private final Function1<Object, A> f;

        @Override
        public Iterator<A> iterator() {
            Function1<Object, A> tabulate_f = this.f;
            int tabulate_end = this.n;
            return new AbstractIterator<A>(tabulate_end, tabulate_f){
                private int i;
                private final int end$1;
                private final Function1 f$5;

                public int knownSize() {
                    int n = this.end$1 - this.i;
                    int max$extension_that = 0;
                    return Math.max(n, max$extension_that);
                }

                public boolean hasNext() {
                    return this.i < this.end$1;
                }

                /*
                 * WARNING - void declaration
                 */
                public A next() {
                    if (this.hasNext()) {
                        void var1_1;
                        R result = this.f$5.apply(this.i);
                        ++this.i;
                        return var1_1;
                    }
                    return (A)Iterator$.scala$collection$Iterator$$_empty.next();
                }
                {
                    this.end$1 = end$1;
                    this.f$5 = f$5;
                    this.i = 0;
                }
            };
        }

        @Override
        public int knownSize() {
            int n = 0;
            int max$extension_that = this.n;
            return Math.max(n, max$extension_that);
        }

        @Override
        public boolean isEmpty() {
            return this.n <= 0;
        }

        public Tabulate(int n, Function1<Object, A> f) {
            this.n = n;
            this.f = f;
        }
    }

    public static class Take<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final int n;
        private final int normN;

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().take(this.n);
        }

        public int normN() {
            return this.normN;
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                int min$extension_that = this.normN();
                return Math.min(size, min$extension_that);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        public Take(IterableOps<A, ?, Object> underlying, int n) {
            this.underlying = underlying;
            this.n = n;
            int max$extension_that = 0;
            this.normN = Math.max(n, max$extension_that);
        }
    }

    public static class TakeRight<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final int n;
        private final int normN;

        @Override
        public Iterator<A> iterator() {
            return View$.MODULE$.takeRightIterator(this.underlying.iterator(), this.n);
        }

        public int normN() {
            return this.normN;
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                int min$extension_that = this.normN();
                return Math.min(size, min$extension_that);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            if (this.knownSize() >= 0) {
                return this.knownSize() == 0;
            }
            return this.iterator().isEmpty();
        }

        public TakeRight(IterableOps<A, ?, Object> underlying, int n) {
            this.underlying = underlying;
            this.n = n;
            int max$extension_that = 0;
            this.normN = Math.max(n, max$extension_that);
        }
    }

    public static final class TakeRightIterator<A>
    extends AbstractIterator<A> {
        private Iterator<A> underlying;
        private final int maxlen;
        private int len;
        private int pos;
        private ArrayBuffer<Object> buf;

        public void init() {
            if (this.buf == null) {
                int n = this.maxlen;
                int min$extension_that = 256;
                this.buf = new ArrayBuffer(Math.min(n, min$extension_that));
                this.len = 0;
                while (this.underlying.hasNext()) {
                    A n2 = this.underlying.next();
                    if (this.pos >= this.buf.length()) {
                        this.buf.addOne((Object)n2);
                    } else {
                        this.buf.update(this.pos, n2);
                    }
                    ++this.pos;
                    if (this.pos == this.maxlen) {
                        this.pos = 0;
                    }
                    ++this.len;
                }
                this.underlying = null;
                if (this.len > this.maxlen) {
                    this.len = this.maxlen;
                }
                this.pos -= this.len;
                if (this.pos < 0) {
                    this.pos += this.maxlen;
                    return;
                }
            }
        }

        @Override
        public int knownSize() {
            return this.len;
        }

        @Override
        public boolean hasNext() {
            this.init();
            return this.len > 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public A next() {
            void var1_1;
            this.init();
            if (this.len == 0) {
                return (A)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            Object x = this.buf.apply(this.pos);
            ++this.pos;
            if (this.pos == this.maxlen) {
                this.pos = 0;
            }
            --this.len;
            return var1_1;
        }

        @Override
        public Iterator<A> drop(int n) {
            this.init();
            if (n > 0) {
                int n2 = this.len - n;
                int max$extension_that = 0;
                this.len = Math.max(n2, max$extension_that);
                this.pos = (this.pos + n) % this.maxlen;
            }
            return this;
        }

        public TakeRightIterator(Iterator<A> underlying, int maxlen) {
            this.underlying = underlying;
            this.maxlen = maxlen;
            this.len = -1;
            this.pos = 0;
        }
    }

    public static class TakeWhile<A>
    extends AbstractView<A> {
        private final IterableOps<A, ?, Object> underlying;
        private final Function1<A, Object> p;

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().takeWhile(this.p);
        }

        @Override
        public int knownSize() {
            if (this.underlying.knownSize() == 0) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        public TakeWhile(IterableOps<A, ?, Object> underlying, Function1<A, Object> p) {
            this.underlying = underlying;
            this.p = p;
        }
    }

    public static class Updated<A>
    extends AbstractView<A> {
        public final IterableOps<A, ?, Object> scala$collection$View$Updated$$underlying;
        public final int scala$collection$View$Updated$$index;
        public final A scala$collection$View$Updated$$elem;

        @Override
        public Iterator<A> iterator() {
            return new AbstractIterator<A>(this){
                private final Iterator<A> it;
                private int i;
                private final /* synthetic */ Updated $outer;

                /*
                 * WARNING - void declaration
                 */
                public A next() {
                    void var1_1;
                    A a;
                    if (this.i == this.$outer.scala$collection$View$Updated$$index) {
                        this.it.next();
                        a = this.$outer.scala$collection$View$Updated$$elem;
                    } else {
                        a = this.it.next();
                    }
                    A value = a;
                    ++this.i;
                    return var1_1;
                }

                public boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (this.$outer.scala$collection$View$Updated$$index >= this.i) {
                        throw new IndexOutOfBoundsException(((Object)this.$outer.scala$collection$View$Updated$$index).toString());
                    }
                    return false;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.it = $outer.scala$collection$View$Updated$$underlying.iterator();
                    this.i = 0;
                }
            };
        }

        @Override
        public int knownSize() {
            return this.scala$collection$View$Updated$$underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }

        public Updated(IterableOps<A, ?, Object> underlying, int index, A elem) {
            this.scala$collection$View$Updated$$underlying = underlying;
            this.scala$collection$View$Updated$$index = index;
            this.scala$collection$View$Updated$$elem = elem;
        }
    }

    public static class Zip<A, B>
    extends AbstractView<Tuple2<A, B>> {
        private final IterableOps<A, ?, Object> underlying;
        private final Iterable<B> other;

        @Override
        public Iterator<Tuple2<A, B>> iterator() {
            return this.underlying.iterator().zip(this.other);
        }

        @Override
        public int knownSize() {
            int s1 = this.underlying.knownSize();
            if (s1 == 0) {
                return 0;
            }
            int s2 = this.other.knownSize();
            if (s2 == 0) {
                return 0;
            }
            return Math.min(s1, s2);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty() || this.other.isEmpty();
        }

        public Zip(IterableOps<A, ?, Object> underlying, Iterable<B> other) {
            this.underlying = underlying;
            this.other = other;
        }
    }

    public static class ZipWithIndex<A>
    extends AbstractView<Tuple2<A, Object>> {
        private final IterableOps<A, ?, Object> underlying;

        @Override
        public Iterator<Tuple2<A, Object>> iterator() {
            return this.underlying.iterator().zipWithIndex();
        }

        @Override
        public int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }

        public ZipWithIndex(IterableOps<A, ?, Object> underlying) {
            this.underlying = underlying;
        }
    }
}

