/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.loggers;

import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Product;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Statics;
import java.io.Serializable;

public abstract class RefreshInfo
implements Serializable,
Product {
    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    @Override
    public String productPrefix() {
        return Product.productPrefix$(this);
    }

    public abstract Option<Object> fraction();

    public abstract boolean watching();

    public RefreshInfo() {
        Product.$init$(this);
    }

    public static final class CheckUpdateInfo
    extends RefreshInfo {
        private final Option<Object> currentTimeOpt;
        private final Option<Object> remoteTimeOpt;
        private final boolean isDone;

        public Option<Object> currentTimeOpt() {
            return this.currentTimeOpt;
        }

        public Option<Object> remoteTimeOpt() {
            return this.remoteTimeOpt;
        }

        public boolean isDone() {
            return this.isDone;
        }

        @Override
        public boolean watching() {
            return false;
        }

        public None$ fraction() {
            return None$.MODULE$;
        }

        public CheckUpdateInfo withRemoteTimeOpt(Option<Object> remoteTimeOpt) {
            return new CheckUpdateInfo(this.currentTimeOpt(), remoteTimeOpt, this.isDone());
        }

        public CheckUpdateInfo withIsDone(boolean isDone) {
            return new CheckUpdateInfo(this.currentTimeOpt(), this.remoteTimeOpt(), isDone);
        }

        public String toString() {
            StringBuilder b = new StringBuilder("CheckUpdateInfo(");
            b.append(String.valueOf(this.currentTimeOpt()));
            b.append(", ");
            b.append(String.valueOf(this.remoteTimeOpt()));
            b.append(", ");
            b.append(String.valueOf(this.isDone()));
            b.append(")");
            return b.toString();
        }

        public boolean canEqual(Object obj) {
            return obj != null && obj instanceof CheckUpdateInfo;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!this.canEqual(obj)) return false;
            CheckUpdateInfo other = (CheckUpdateInfo)obj;
            if (!true) return false;
            Option<Object> option = this.currentTimeOpt();
            Option<Object> option2 = other.currentTimeOpt();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.remoteTimeOpt();
            Option<Object> option4 = other.remoteTimeOpt();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (this.isDone() != other.isDone()) return false;
            return true;
        }

        public int hashCode() {
            int code = 17 + Statics.anyHash("CheckUpdateInfo");
            code = 37 * code + Statics.anyHash(this.currentTimeOpt());
            code = 37 * code + Statics.anyHash(this.remoteTimeOpt());
            code = 37 * code + (this.isDone() ? 1231 : 1237);
            return 37 * code;
        }

        @Override
        public String productPrefix() {
            return "CheckUpdateInfo";
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public Object productElement(int n) {
            Serializable serializable;
            int n2 = n;
            switch (n2) {
                case 0: {
                    serializable = this.currentTimeOpt();
                    break;
                }
                case 1: {
                    serializable = this.remoteTimeOpt();
                    break;
                }
                case 2: {
                    serializable = BoxesRunTime.boxToBoolean(this.isDone());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(n2)).toString());
                }
            }
            return serializable;
        }

        public CheckUpdateInfo(Option<Object> currentTimeOpt, Option<Object> remoteTimeOpt, boolean isDone) {
            this.currentTimeOpt = currentTimeOpt;
            this.remoteTimeOpt = remoteTimeOpt;
            this.isDone = isDone;
        }
    }

    public static final class DownloadInfo
    extends RefreshInfo {
        private final long downloaded;
        private final long previouslyDownloaded;
        private final Option<Object> length;
        private final long startTime;
        private final boolean updateCheck;
        private final boolean watching;

        public long downloaded() {
            return this.downloaded;
        }

        public long previouslyDownloaded() {
            return this.previouslyDownloaded;
        }

        public Option<Object> length() {
            return this.length;
        }

        public long startTime() {
            return this.startTime;
        }

        public boolean updateCheck() {
            return this.updateCheck;
        }

        @Override
        public boolean watching() {
            return this.watching;
        }

        @Override
        public Option<Object> fraction() {
            return this.length().map(x$1 -> (double)this.downloaded() / (double)x$1);
        }

        public Option<Object> rate() {
            long currentTime = System.currentTimeMillis();
            return currentTime > this.startTime() ? new Some<Double>(BoxesRunTime.boxToDouble((double)(this.downloaded() - this.previouslyDownloaded()) / (double)(System.currentTimeMillis() - this.startTime()) * 1000.0)) : None$.MODULE$;
        }

        public DownloadInfo withDownloaded(long downloaded) {
            return new DownloadInfo(downloaded, this.previouslyDownloaded(), this.length(), this.startTime(), this.updateCheck(), this.watching());
        }

        public DownloadInfo withPreviouslyDownloaded(long previouslyDownloaded) {
            return new DownloadInfo(this.downloaded(), previouslyDownloaded, this.length(), this.startTime(), this.updateCheck(), this.watching());
        }

        public DownloadInfo withLength(Option<Object> length) {
            return new DownloadInfo(this.downloaded(), this.previouslyDownloaded(), length, this.startTime(), this.updateCheck(), this.watching());
        }

        public DownloadInfo withWatching(boolean watching) {
            return new DownloadInfo(this.downloaded(), this.previouslyDownloaded(), this.length(), this.startTime(), this.updateCheck(), watching);
        }

        public String toString() {
            StringBuilder b = new StringBuilder("DownloadInfo(");
            b.append(String.valueOf(this.downloaded()));
            b.append(", ");
            b.append(String.valueOf(this.previouslyDownloaded()));
            b.append(", ");
            b.append(String.valueOf(this.length()));
            b.append(", ");
            b.append(String.valueOf(this.startTime()));
            b.append(", ");
            b.append(String.valueOf(this.updateCheck()));
            b.append(", ");
            b.append(String.valueOf(this.watching()));
            b.append(")");
            return b.toString();
        }

        public boolean canEqual(Object obj) {
            return obj != null && obj instanceof DownloadInfo;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!this.canEqual(obj)) return false;
            DownloadInfo other = (DownloadInfo)obj;
            if (!true) return false;
            if (this.downloaded() != other.downloaded()) return false;
            if (this.previouslyDownloaded() != other.previouslyDownloaded()) return false;
            Option<Object> option = this.length();
            Option<Object> option2 = other.length();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (this.startTime() != other.startTime()) return false;
            if (this.updateCheck() != other.updateCheck()) return false;
            if (this.watching() != other.watching()) return false;
            return true;
        }

        public int hashCode() {
            int code = 17 + Statics.anyHash("DownloadInfo");
            code = 37 * code + Statics.longHash(this.downloaded());
            code = 37 * code + Statics.longHash(this.previouslyDownloaded());
            code = 37 * code + Statics.anyHash(this.length());
            code = 37 * code + Statics.longHash(this.startTime());
            code = 37 * code + (this.updateCheck() ? 1231 : 1237);
            code = 37 * code + (this.watching() ? 1231 : 1237);
            return 37 * code;
        }

        @Override
        public String productPrefix() {
            return "DownloadInfo";
        }

        @Override
        public int productArity() {
            return 6;
        }

        @Override
        public Object productElement(int n) {
            Serializable serializable;
            int n2 = n;
            switch (n2) {
                case 0: {
                    serializable = BoxesRunTime.boxToLong(this.downloaded());
                    break;
                }
                case 1: {
                    serializable = BoxesRunTime.boxToLong(this.previouslyDownloaded());
                    break;
                }
                case 2: {
                    serializable = this.length();
                    break;
                }
                case 3: {
                    serializable = BoxesRunTime.boxToLong(this.startTime());
                    break;
                }
                case 4: {
                    serializable = BoxesRunTime.boxToBoolean(this.updateCheck());
                    break;
                }
                case 5: {
                    serializable = BoxesRunTime.boxToBoolean(this.watching());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(n2)).toString());
                }
            }
            return serializable;
        }

        public DownloadInfo(long downloaded, long previouslyDownloaded, Option<Object> length, long startTime, boolean updateCheck, boolean watching) {
            this.downloaded = downloaded;
            this.previouslyDownloaded = previouslyDownloaded;
            this.length = length;
            this.startTime = startTime;
            this.updateCheck = updateCheck;
            this.watching = watching;
        }
    }
}

