/*
 * Decompiled with CFR 0.152.
 */
package coursierapi;

import coursierapi.Cache;
import coursierapi.Module;
import coursierapi.Repository;
import coursierapi.VersionsResult;
import coursierapi.error.CoursierError;
import coursierapi.shaded.coursier.internal.api.ApiHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Versions {
    private final List<Repository> repositories = new ArrayList<Repository>(Arrays.asList(ApiHelper.defaultRepositories()));
    private Cache cache = Cache.create();
    private Module module = null;

    private Versions() {
    }

    public static Versions create() {
        return new Versions();
    }

    public boolean equals(Object object) {
        if (object instanceof Versions) {
            Versions versions2 = (Versions)object;
            return this.repositories.equals(versions2.repositories) && this.cache.equals(versions2.cache) && Objects.equals(this.module, versions2.module);
        }
        return false;
    }

    public int hashCode() {
        return 37 * (37 * (37 * (17 + "coursierapi.Versions".hashCode()) + this.repositories.hashCode()) + this.cache.hashCode()) + Objects.hashCode(this.module);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Versions(repositories=[");
        for (Repository repository : this.repositories) {
            stringBuilder.append(repository.toString());
            stringBuilder.append(", ");
        }
        stringBuilder.append("], cache=");
        stringBuilder.append(this.cache.toString());
        stringBuilder.append("], module=");
        stringBuilder.append(this.module);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public Versions addRepositories(Repository ... repositoryArray) {
        this.repositories.addAll(Arrays.asList(repositoryArray));
        return this;
    }

    public Versions withRepositories(Repository ... repositoryArray) {
        this.repositories.clear();
        this.repositories.addAll(Arrays.asList(repositoryArray));
        return this;
    }

    public Versions withCache(Cache cache) {
        this.cache = cache;
        return this;
    }

    public Versions withModule(Module module) {
        this.module = module;
        return this;
    }

    public List<Repository> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    public Cache getCache() {
        return this.cache;
    }

    public Module getModule() {
        return this.module;
    }

    public VersionsResult versions() throws CoursierError {
        return ApiHelper.getVersions(this);
    }
}

