/*
 * Decompiled with CFR 0.152.
 */
package coursierapi;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class DependencyManagement {
    private DependencyManagement() {
    }

    public static final class Values {
        private final String configuration;
        private final String version;
        private final Set<Map.Entry<String, String>> exclusions = new HashSet<Map.Entry<String, String>>();
        private final boolean optional;

        public Values(String string, String string2, boolean bl) {
            this.configuration = string;
            this.version = string2;
            this.optional = bl;
        }

        public Values addExclusion(String string, String string2) {
            this.exclusions.add(new AbstractMap.SimpleImmutableEntry<String, String>(string, string2));
            return this;
        }

        public Values addExclusions(Set<Map.Entry<String, String>> set) {
            this.exclusions.addAll(set);
            return this;
        }

        public String getConfiguration() {
            return this.configuration;
        }

        public String getVersion() {
            return this.version;
        }

        public Set<Map.Entry<String, String>> getExclusions() {
            return Collections.unmodifiableSet(this.exclusions);
        }

        public boolean isOptional() {
            return this.optional;
        }

        public Values withConfiguration(String string) {
            Values values = new Values(string, this.version, this.optional);
            values.addExclusions(this.exclusions);
            return values;
        }

        public Values withVersion(String string) {
            Values values = new Values(this.configuration, string, this.optional);
            values.addExclusions(this.exclusions);
            return values;
        }

        public Values withExclusions(Set<Map.Entry<String, String>> set) {
            Values values = new Values(this.configuration, this.version, this.optional);
            values.addExclusions(set);
            return values;
        }

        public Values withOptional(boolean bl) {
            Values values = new Values(this.configuration, this.version, bl);
            values.addExclusions(this.exclusions);
            return values;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Values)) {
                return false;
            }
            Values values = (Values)object;
            return this.optional == values.optional && Objects.equals(this.configuration, values.configuration) && Objects.equals(this.version, values.version) && Objects.equals(this.exclusions, values.exclusions);
        }

        public int hashCode() {
            return Objects.hash(this.configuration, this.version, this.exclusions, this.optional);
        }

        public String toString() {
            return "Values{configuration='" + this.configuration + '\'' + ", version='" + this.version + '\'' + ", exclusions=" + this.exclusions + ", optional=" + this.optional + '}';
        }
    }

    public static final class Key {
        private final String organization;
        private final String name;
        private final String type;
        private final String classifier;

        public Key(String string, String string2, String string3, String string4) {
            this.organization = string;
            this.name = string2;
            this.type = string3;
            this.classifier = string4;
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public Key withOrganization(String string) {
            return new Key(string, this.name, this.type, this.classifier);
        }

        public Key withName(String string) {
            return new Key(this.organization, string, this.type, this.classifier);
        }

        public Key withType(String string) {
            return new Key(this.organization, this.name, string, this.classifier);
        }

        public Key withClassifier(String string) {
            return new Key(this.organization, this.name, this.type, string);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            return Objects.equals(this.organization, key.organization) && Objects.equals(this.name, key.name) && Objects.equals(this.type, key.type) && Objects.equals(this.classifier, key.classifier);
        }

        public int hashCode() {
            return Objects.hash(this.organization, this.name, this.type, this.classifier);
        }

        public String toString() {
            return "Key{organization='" + this.organization + '\'' + ", name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", classifier='" + this.classifier + '\'' + '}';
        }
    }
}

