/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.compressors.zstandard;

import coursierapi.shaded.commonscompress.compressors.CompressorInputStream;
import coursierapi.shaded.commonscompress.utils.CountingInputStream;
import coursierapi.shaded.commonscompress.utils.IOUtils;
import coursierapi.shaded.zstd.ZstdInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZstdCompressorInputStream
extends CompressorInputStream {
    private final CountingInputStream countingStream;
    private final ZstdInputStream decIS;

    public ZstdCompressorInputStream(InputStream in) throws IOException {
        this.countingStream = new CountingInputStream(in);
        this.decIS = new ZstdInputStream(this.countingStream);
    }

    @Override
    public int available() throws IOException {
        return this.decIS.available();
    }

    @Override
    public void close() throws IOException {
        this.decIS.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.decIS.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.decIS.markSupported();
    }

    @Override
    public int read() throws IOException {
        int ret = this.decIS.read();
        this.count(ret == -1 ? 0 : 1);
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int ret = this.decIS.read(buf, off, len);
        this.count(ret);
        return ret;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.decIS.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return IOUtils.skip(this.decIS, n);
    }

    public String toString() {
        return this.decIS.toString();
    }
}

