/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.stats.Ranges;
import io.gatling.charts.util.Color;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005y2Q\u0001C\u0005\u0001\u0017MA\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IA\u0007\u0005\tO\u0001\u0011\t\u0011)A\u00055!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0015Y\u0004\u0001\"\u0011=\u0011\u0015i\u0004\u0001\"\u0011=\u00059\u0011\u0016M\\4fgR+W\u000e\u001d7bi\u0016T!AC\u0006\u0002\u0011Q,W\u000e\u001d7bi\u0016T!\u0001D\u0007\u0002\u0015!Lw\r[2iCJ$8O\u0003\u0002\u000f\u001f\u000511\r[1siNT!\u0001E\t\u0002\u000f\u001d\fG\u000f\\5oO*\t!#\u0001\u0002j_N\u0011\u0001\u0001\u0006\t\u0003+Yi\u0011!C\u0005\u0003/%\u0011\u0001\u0002V3na2\fG/Z\u0001\u000bG\"\f'\u000f\u001e+ji2,7\u0001\u0001\t\u00037\u0011r!\u0001\b\u0012\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}I\u0012A\u0002\u001fs_>$hHC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003%\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u0019\u0012aa\u0015;sS:<'BA\u0012!\u0003%)g/\u001a8u\u001d\u0006lW-\u0001\u0004sC:<Wm\u001d\t\u0003U5j\u0011a\u000b\u0006\u0003Y5\tQa\u001d;biNL!AL\u0016\u0003\rI\u000bgnZ3t\u0003\u0015a\u0017M]4f!\t\t$'D\u0001!\u0013\t\u0019\u0004EA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u00151t\u0007O\u001d;!\t)\u0002\u0001C\u0003\u0019\u000b\u0001\u0007!\u0004C\u0003(\u000b\u0001\u0007!\u0004C\u0003)\u000b\u0001\u0007\u0011\u0006C\u00030\u000b\u0001\u0007\u0001'\u0001\u0002kgV\t!$\u0001\u0003ii6d\u0007")
public class RangesTemplate
extends Template {
    private final String chartTitle;
    private final String eventName;
    private final Ranges ranges;
    private final boolean large;

    @Override
    public String js() {
        return "\nHighcharts.setOptions({\n  global: { useUTC: false }\n});\n\nnew Highcharts.Chart({\n  chart: {\n    renderTo: 'ranges',\n    marginRight: 100\n  },\n  credits: { enabled: false },\n  legend: { enabled: false },\n  title: {\n    text: '<span class=\"chart_title\">" + this.chartTitle + "</span>',\n    useHTML: true\n  },\n  xAxis: {\n    categories: [\n      \"t < " + this.ranges.lowerBound() + " ms\",\n      \"t >= " + this.ranges.lowerBound() + " ms <br> t < " + this.ranges.higherBound() + " ms\",\n      \"t >= " + this.ranges.higherBound() + " ms\",\n      \"failed\"\n    ]\n  },\n  yAxis: {\n    title: { text: 'Number of " + StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(this.eventName)) + "' },\n    reversedStacks: false\n  },\n  tooltip: {\n    formatter: function() {\n      var s;\n      if (this.point.name) { // the pie chart\n        s = ''+ this.point.name +': '+ this.y +'% " + this.eventName + "';\n      } else {\n        s = ''+ this.y + ' " + this.eventName + "';\n      }\n      return s;\n    }\n  },\n  plotOptions: {\n    series: {\n      stacking: 'normal',\n      shadow: true\n    }\n  },\n  series: [\n    {\n      type: 'column',\n      data: [{\n      \tcolor: '" + Color.Requests$.MODULE$.Ok() + "',\n      \ty: " + this.ranges.lowCount() + "\n      },\n      {\n      \tcolor: '" + Color.Requests$.MODULE$.Fine() + "',\n      \ty: " + this.ranges.middleCount() + "\n      },\n      {\n      \tcolor: '" + Color.Requests$.MODULE$.Poor() + "',\n      \ty: " + this.ranges.highCount() + "\n      },\n      {\n      \tcolor: '" + Color.Requests$.MODULE$.Ko() + "',\n      \ty: " + this.ranges.koCount() + "\n      }]\n    },\n    {\n      type: 'pie',\n      name: 'Percentages',\n      data: [\n        {\n          name: \"t < " + this.ranges.lowerBound() + " ms\",\n          y: " + this.ranges.lowPercentage() + ",\n          color: '" + Color.Requests$.MODULE$.Ok() + "'\n        },\n        {\n          name: \"" + this.ranges.lowerBound() + " ms <= t < " + this.ranges.higherBound() + " ms\",\n          y: " + this.ranges.middlePercentage() + ",\n          color: '" + Color.Requests$.MODULE$.Fine() + "'\n        },\n        {\n          name: \"t >= " + this.ranges.higherBound() + " ms\",\n          y: " + this.ranges.highPercentage() + ",\n          color: '" + Color.Requests$.MODULE$.Poor() + "'\n        },\n        {\n          name: \"failed\",\n          y: " + this.ranges.koPercentage() + ",\n          color: '" + Color.Requests$.MODULE$.Ko() + "'\n        }\n      ],\n      center: [" + (this.large ? "368" : "345") + ", 0],\n      size: 90,\n      showInLegend: false,\n      dataLabels: { enabled: false }\n    }\n  ]\n});\n";
    }

    @Override
    public String html() {
        return "\n            <div id=\"ranges\" class=\"schema " + (this.large ? "ranges-large" : "ranges") + "\">\n            </div>\n";
    }

    public RangesTemplate(String chartTitle, String eventName, Ranges ranges, boolean large) {
        this.chartTitle = chartTitle;
        this.eventName = eventName;
        this.ranges = ranges;
        this.large = large;
    }
}

