/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.stats.IntVsTimePlot;
import io.gatling.charts.stats.Series$;
import io.gatling.charts.util.Color;
import java.io.Serializable;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005U3QAC\u0006\u0003\u001bUA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\ta\u0001\u0011\t\u0011)A\u00059!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u00033\u0011!Y\u0004A!A!\u0002\u0013\u0011\u0004\"\u0002\u001f\u0001\t\u0003i\u0004\"\u0002#\u0001\t\u0003*\u0005\"\u0002$\u0001\t\u00139\u0005\"\u0002+\u0001\t\u0003*%a\u0007*fgB|gn]3US6,7kY1ui\u0016\u0014H+Z7qY\u0006$XM\u0003\u0002\r\u001b\u0005AA/Z7qY\u0006$XM\u0003\u0002\u000f\u001f\u0005Q\u0001.[4iG\"\f'\u000f^:\u000b\u0005A\t\u0012AB2iCJ$8O\u0003\u0002\u0013'\u00059q-\u0019;mS:<'\"\u0001\u000b\u0002\u0005%|7C\u0001\u0001\u0017!\t9\u0002$D\u0001\f\u0013\tI2B\u0001\u0005UK6\u0004H.\u0019;f\u0003\u001d\u0019XoY2fgN\u001c\u0001\u0001E\u0002\u001eO)r!A\b\u0013\u000f\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005Z\u0012A\u0002\u001fs_>$h(C\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)c%A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\rJ!\u0001K\u0015\u0003\u0007M+\u0017O\u0003\u0002&MA\u00111FL\u0007\u0002Y)\u0011QfD\u0001\u0006gR\fGo]\u0005\u0003_1\u0012Q\"\u00138u-N$\u0016.\\3QY>$\u0018\u0001\u00034bS2,(/Z:\u0002\u001b\r|g\u000e^1j]\u0016\u0014h*Y7f!\t\u0019tG\u0004\u00025kA\u0011qDJ\u0005\u0003m\u0019\na\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011aGJ\u0001\u000bG\"\f'\u000f\u001e+ji2,\u0017AC=Bq&\u001cH+\u001b;mK\u00061A(\u001b8jiz\"bAP A\u0003\n\u001b\u0005CA\f\u0001\u0011\u0015Qb\u00011\u0001\u001d\u0011\u0015\u0001d\u00011\u0001\u001d\u0011\u0015\td\u00011\u00013\u0011\u0015Qd\u00011\u00013\u0011\u0015Yd\u00011\u00013\u0003\tQ7/F\u00013\u0003M\u0011XM\u001c3feN\u001b\u0017\r\u001e;feN+'/[3t)\u0011\u0011\u0004J\u0013'\t\u000b%C\u0001\u0019\u0001\u000f\u0002\rM,'/[3t\u0011\u0015Y\u0005\u00021\u00013\u0003\u0011q\u0017-\\3\t\u000b5C\u0001\u0019\u0001(\u0002\u000b\r|Gn\u001c:\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E{\u0011\u0001B;uS2L!a\u0015)\u0003\u000b\r{Gn\u001c:\u0002\t!$X\u000e\u001c")
public final class ResponseTimeScatterTemplate
extends Template {
    private final Seq<IntVsTimePlot> success;
    private final Seq<IntVsTimePlot> failures;
    private final String containerName;
    private final String chartTitle;
    private final String yAxisTitle;

    @Override
    public String js() {
        return "\nnew Highcharts.Chart({\n  chart: {\n    renderTo: '" + this.containerName + "', \n    defaultSeriesType: 'scatter',\n    zoomType: 'xy',\n    marginBottom: 90\n  },\n  credits: { enabled: false },\n  xAxis: {\n    title: {\n      enabled: true,\n      text: 'Global number of requests per second',\n      style: { fontWeight: 'bold' }\n    },\n    startOnTick: true,\n    endOnTick: true,\n    showLastLabel: true,\n    min: 0\n  },\n  title: {\n    text: '<span class=\"chart_title\">" + this.chartTitle + "</span>',\n    useHTML: true\n  },\n  yAxis: {\n    min: 0,\n    title: { text: '" + this.yAxisTitle + "' }\n  },\n  tooltip: {\n    formatter: function() {\n         return ''+ this.y +' ms at ' + this.x + ' allreq/s';\n    }\n  },\n  legend: {\n    enabled: true,\n    floating: true,\n    y: 0,\n    borderWidth: 0,\n    itemStyle: { fontWeight: \"normal\" },\n  },\n  plotOptions: {\n    scatter: {\n      marker: {\n        radius: 3,\n        states: {\n          hover: {\n            enabled: true,\n            lineColor: 'rgb(100,100,100)'\n          }\n        }\n      },\n      states: {\n        hover: {\n          marker: { enabled: false }\n        }\n      }\n    }\n  },\n  series: [\n\t  {" + this.renderScatterSeries(this.success, Series$.MODULE$.OK(), Color.Requests$.MODULE$.Ok()) + "},\n\t  {" + this.renderScatterSeries(this.failures, Series$.MODULE$.KO(), Color.Requests$.MODULE$.Ko()) + "}\n\t]\n});\n";
    }

    private String renderScatterSeries(Seq<IntVsTimePlot> series, String name, Color color) {
        return "\ntype: 'scatter',\ncolor: '" + color + "',\nname: '" + name + "',\ndata: [\n" + ((IterableOnceOps)series.map((Function1 & Serializable)plot -> "[" + plot.time() + "," + plot.value() + "]")).mkString(",") + "\n]";
    }

    @Override
    public String html() {
        return "\n            <div class=\"schema geant\">\n              <div id=\"" + this.containerName + "\" class=\"geant\"></div>\n            </div>\n";
    }

    public ResponseTimeScatterTemplate(Seq<IntVsTimePlot> success, Seq<IntVsTimePlot> failures, String containerName, String chartTitle, String yAxisTitle) {
        this.success = success;
        this.failures = failures;
        this.containerName = containerName;
        this.chartTitle = chartTitle;
        this.yAxisTitle = yAxisTitle;
    }
}

