/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine.response;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Failure;
import io.gatling.core.session.Session;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.check.HttpCheck;
import io.gatling.http.client.Request;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.cookie.CookieSupport$;
import io.gatling.http.engine.response.CheckProcessor$;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055d!B\b\u0011\u0003CY\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001dB\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u0015\u0019\b\u0001\"\u0003u\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007Aq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u0002H\u0001!I!!\u0013\t\u000f\u0005E\u0003A\"\u0005\u0002T!9\u0011\u0011\f\u0001\u0007\u0012\u0005m#\u0001E*fgNLwN\u001c)s_\u000e,7o]8s\u0015\t\t\"#\u0001\u0005sKN\u0004xN\\:f\u0015\t\u0019B#\u0001\u0004f]\u001eLg.\u001a\u0006\u0003+Y\tA\u0001\u001b;ua*\u0011q\u0003G\u0001\bO\u0006$H.\u001b8h\u0015\u0005I\u0012AA5p\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\r\u0005s\u0017PU3g\u0003%qw\u000e^*jY\u0016tG\u000f\u0005\u0002\u001eI%\u0011QE\b\u0002\b\u0005>|G.Z1o\u0003\u001d\u0011X-];fgR\u0004\"\u0001K\u0016\u000e\u0003%R!A\u000b\u000b\u0002\r\rd\u0017.\u001a8u\u0013\ta\u0013FA\u0004SKF,Xm\u001d;\u0002\r\rDWmY6t!\rysG\u000f\b\u0003aUr!!\r\u001b\u000e\u0003IR!a\r\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0012B\u0001\u001c\u001f\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001O\u001d\u0003\t1K7\u000f\u001e\u0006\u0003my\u0001\"a\u000f \u000e\u0003qR!!\u0010\u000b\u0002\u000b\rDWmY6\n\u0005}b$!\u0003%uiB\u001c\u0005.Z2l\u0003)AG\u000f\u001e9DC\u000eDWm\u001d\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tR\tQaY1dQ\u0016L!AR\"\u0003\u0015!#H\u000f]\"bG\",7/\u0001\u0007iiR\u0004\bK]8u_\u000e|G\u000e\u0005\u0002J\u00196\t!J\u0003\u0002L)\u0005A\u0001O]8u_\u000e|G.\u0003\u0002N\u0015\na\u0001\n\u001e;q!J|Go\\2pY\u0006)1\r\\8dWB\u0011\u0001+V\u0007\u0002#*\u0011!kU\u0001\u0005kRLGN\u0003\u0002U-\u000591m\\7n_:\u001c\u0018B\u0001,R\u0005\u0015\u0019En\\2l\u0003\u0019a\u0014N\\5u}Q9\u0011l\u0017/^=~\u0003\u0007C\u0001.\u0001\u001b\u0005\u0001\u0002\"\u0002\u0012\b\u0001\u0004\u0019\u0003\"\u0002\u0014\b\u0001\u00049\u0003\"B\u0017\b\u0001\u0004q\u0003\"\u0002!\b\u0001\u0004\t\u0005\"B$\b\u0001\u0004A\u0005\"\u0002(\b\u0001\u0004y\u0015\u0001F;qI\u0006$XmU3tg&|gn\u0011:bg\",G\r\u0006\u0003dW2\f\bC\u00013j\u001b\u0005)'B\u00014h\u0003\u001d\u0019Xm]:j_:T!\u0001\u001b\f\u0002\t\r|'/Z\u0005\u0003U\u0016\u0014qaU3tg&|g\u000eC\u0003g\u0011\u0001\u00071\rC\u0003n\u0011\u0001\u0007a.\u0001\bti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9\u0011\u0005uy\u0017B\u00019\u001f\u0005\u0011auN\\4\t\u000bID\u0001\u0019\u00018\u0002\u0019\u0015tG\rV5nKN$\u0018-\u001c9\u0002%U\u0004H-\u0019;f'\u0016\u001c8/[8o'R\fGo\u001d\u000b\u0006GV4x\u000f\u001f\u0005\u0006M&\u0001\ra\u0019\u0005\u0006[&\u0001\rA\u001c\u0005\u0006e&\u0001\rA\u001c\u0005\u0006s&\u0001\rA_\u0001\u0007gR\fG/^:\u0011\u0005mtX\"\u0001?\u000b\u0005u\u001c\u0016!B:uCR\u001c\u0018BA@}\u0005\u0019\u0019F/\u0019;vg\u0006qQ\u000f\u001d3bi\u0016$7+Z:tS>tGCBA\u0003\u0003C\t\u0019\u0003\u0005\u0004\u001e\u0003\u000f\u0019\u00171B\u0005\u0004\u0003\u0013q\"A\u0002+va2,'\u0007E\u0003\u001e\u0003\u001b\t\t\"C\u0002\u0002\u0010y\u0011aa\u00149uS>t\u0007\u0003BA\n\u00037qA!!\u0006\u0002\u0018A\u0011\u0011GH\u0005\u0004\u00033q\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001e\u0005}!AB*ue&twMC\u0002\u0002\u001ayAQA\u001a\u0006A\u0002\rDa!\u0005\u0006A\u0002\u0005\u0015\u0002\u0003BA\u0014\u0003Wi!!!\u000b\u000b\u0005E!\u0012\u0002BA\u0017\u0003S\u0011\u0001BU3ta>t7/Z\u0001\u0017kB$\u0017\r^3e%\u0016$\u0017N]3diN+7o]5p]R91-a\r\u00026\u0005]\u0002\"\u00024\f\u0001\u0004\u0019\u0007BB\t\f\u0001\u0004\t)\u0003C\u0004\u0002:-\u0001\r!a\u000f\u0002\u0017I,G-\u001b:fGR,&/\u001b\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011I\u0015\u0002\u0007U\u0014\u0018.\u0003\u0003\u0002F\u0005}\"aA+sS\u0006i1-Y2iKJ+G-\u001b:fGR$raYA&\u0003\u001b\ny\u0005C\u0003g\u0019\u0001\u00071\r\u0003\u0004\u0012\u0019\u0001\u0007\u0011Q\u0005\u0005\b\u0003sa\u0001\u0019AA\u001e\u00035)\b\u000fZ1uKJ+g-\u001a:feR)1-!\u0016\u0002X!)a-\u0004a\u0001G\"1\u0011#\u0004a\u0001\u0003K\t\u0011$\u001e9eCR,wI]8vaJ+\u0017/^3tiRKW.\u001b8hgR91-!\u0018\u0002`\u0005\u0005\u0004\"\u00024\u000f\u0001\u0004\u0019\u0007\"B7\u000f\u0001\u0004q\u0007\"\u0002:\u000f\u0001\u0004q\u0017&\u0002\u0001\u0002f\u0005%\u0014bAA4!\tA\"+Z:pkJ\u001cWmU3tg&|g\u000e\u0015:pG\u0016\u001c8o\u001c:\n\u0007\u0005-\u0004C\u0001\u000bS_>$8+Z:tS>t\u0007K]8dKN\u001cxN\u001d")
public abstract class SessionProcessor {
    private final boolean notSilent;
    private final Request request;
    private final List<HttpCheck> checks;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final Clock clock;

    public Session updateSessionCrashed(Session session, long startTimestamp, long endTimestamp) {
        return this.updateSessionStats(session, startTimestamp, endTimestamp, (Status)KO$.MODULE$);
    }

    private Session updateSessionStats(Session session, long startTimestamp, long endTimestamp, Status status) {
        Session session2;
        if (this.notSilent) {
            Status status2 = status;
            KO$ kO$ = KO$.MODULE$;
            Session sessionWithUpdatedStatus = !(status2 != null ? !status2.equals(kO$) : kO$ != null) ? session.markAsFailed() : session;
            session2 = this.updateGroupRequestTimings(sessionWithUpdatedStatus, startTimestamp, endTimestamp);
        } else {
            session2 = session;
        }
        return session2;
    }

    public Tuple2<Session, Option<String>> updatedSession(Session session, Response response) {
        Tuple2<Session, Option<Failure>> tuple2 = CheckProcessor$.MODULE$.check(session, response, this.checks);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Session sessionWithCheckSavedValues = (Session)tuple2._1();
        Option checkError = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sessionWithCheckSavedValues, (Object)checkError);
        Tuple2 tuple23 = tuple22;
        Session sessionWithCheckSavedValues2 = (Session)tuple23._1();
        Option checkError2 = (Option)tuple23._2();
        Session sessionWithHttp2PriorKnowledge = this.httpProtocol.enginePart().enableHttp2() ? this.httpCaches.updateSessionHttp2PriorKnowledge(sessionWithCheckSavedValues2, response) : sessionWithCheckSavedValues2;
        KO$ newStatus = checkError2.isDefined() ? KO$.MODULE$ : OK$.MODULE$;
        Session newSession = this.updateSessionAfterChecks$1(sessionWithHttp2PriorKnowledge, (Status)newStatus, response);
        return new Tuple2((Object)newSession, (Object)checkError2.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.message()));
    }

    public Session updatedRedirectSession(Session session, Response response, Uri redirectUri) {
        Session sessionWithCookieStoreUpdate = CookieSupport$.MODULE$.storeCookies(session, this.request.getUri(), response.cookies(), this.clock.nowMillis());
        Session sessionWithGroupUpdate = this.updateSessionStats(sessionWithCookieStoreUpdate, response.startTimestamp(), response.endTimestamp(), (Status)OK$.MODULE$);
        return this.cacheRedirect(sessionWithGroupUpdate, response, redirectUri);
    }

    private Session cacheRedirect(Session session, Response response, Uri redirectUri) {
        return this.httpProtocol.requestPart().cache() && HttpHelper$.MODULE$.isPermanentRedirect(response.status()) ? this.httpCaches.addRedirect(session, this.request, redirectUri) : session;
    }

    public abstract Session updateReferer(Session var1, Response var2);

    public abstract Session updateGroupRequestTimings(Session var1, long var2, long var4);

    private final Session updateSessionAfterChecks$1(Session s1, Status status, Response response$1) {
        Session s2 = CookieSupport$.MODULE$.storeCookies(s1, this.request.getUri(), response$1.cookies(), this.clock.nowMillis());
        Session s3 = this.updateReferer(s2, response$1);
        Session s4 = this.httpCaches.cacheContent(s3, this.httpProtocol, this.request, response$1);
        return this.updateSessionStats(s4, response$1.startTimestamp(), response$1.endTimestamp(), status);
    }

    public SessionProcessor(boolean notSilent, Request request, List<HttpCheck> checks, HttpCaches httpCaches, HttpProtocol httpProtocol, Clock clock) {
        this.notSilent = notSilent;
        this.request = request;
        this.checks = checks;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.clock = clock;
    }
}

