/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.sbt;

import io.gatling.app.Gatling$;
import io.gatling.app.cli.StatusCode;
import io.gatling.sbt.InvalidArguments;
import io.gatling.sbt.SimulationFailed;
import io.gatling.sbt.SimulationSuccessful;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import sbt.testing.Event;
import sbt.testing.EventHandler;
import sbt.testing.Fingerprint;
import sbt.testing.Logger;
import sbt.testing.OptionalThrowable;
import sbt.testing.Selector;
import sbt.testing.Task;
import sbt.testing.TaskDef;
import sbt.testing.TestSelector;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005a3AAC\u0006\u0001%!A!\u0005\u0001BC\u0002\u0013\u00051\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003%\u0011!A\u0003A!A!\u0002\u0013I\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011y\u0002!\u0011!Q\u0001\n5BQa\u0010\u0001\u0005\u0002\u0001Cqa\u0012\u0001C\u0002\u0013\u0005\u0003\n\u0003\u0004J\u0001\u0001\u0006I!\f\u0005\u0006\u0015\u0002!\ta\u0013\u0002\f\u000f\u0006$H.\u001b8h)\u0006\u001c8N\u0003\u0002\r\u001b\u0005\u00191O\u0019;\u000b\u00059y\u0011aB4bi2Lgn\u001a\u0006\u0002!\u0005\u0011\u0011n\\\u0002\u0001'\r\u00011c\u0007\t\u0003)ei\u0011!\u0006\u0006\u0003-]\tA\u0001\\1oO*\t\u0001$\u0001\u0003kCZ\f\u0017B\u0001\u000e\u0016\u0005\u0019y%M[3diB\u0011A\u0004I\u0007\u0002;)\u0011adH\u0001\bi\u0016\u001cH/\u001b8h\u0015\u0005a\u0011BA\u0011\u001e\u0005\u0011!\u0016m]6\u0002\u000fQ\f7o\u001b#fMV\tA\u0005\u0005\u0002\u001dK%\u0011a%\b\u0002\b)\u0006\u001c8\u000eR3g\u0003!!\u0018m]6EK\u001a\u0004\u0013a\u0004;fgR\u001cE.Y:t\u0019>\fG-\u001a:\u0011\u0005QQ\u0013BA\u0016\u0016\u0005-\u0019E.Y:t\u0019>\fG-\u001a:\u0002\t\u0005\u0014xm\u001d\t\u0004]E\u001aT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\u000b\u0005\u0013(/Y=\u0011\u0005QZdBA\u001b:!\t1t&D\u00018\u0015\tA\u0014#\u0001\u0004=e>|GOP\u0005\u0003u=\na\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!hL\u0001\u000be\u0016lw\u000e^3Be\u001e\u001c\u0018A\u0002\u001fj]&$h\bF\u0003B\u0007\u0012+e\t\u0005\u0002C\u00015\t1\u0002C\u0003#\r\u0001\u0007A\u0005C\u0003)\r\u0001\u0007\u0011\u0006C\u0003-\r\u0001\u0007Q\u0006C\u0003?\r\u0001\u0007Q&\u0001\u0003uC\u001e\u001cX#A\u0017\u0002\u000bQ\fwm\u001d\u0011\u0002\u000f\u0015DXmY;uKR\u0019A*\u0014*\u0011\u00079\n4\u0004C\u0003O\u0013\u0001\u0007q*\u0001\u0007fm\u0016tG\u000fS1oI2,'\u000f\u0005\u0002\u001d!&\u0011\u0011+\b\u0002\r\u000bZ,g\u000e\u001e%b]\u0012dWM\u001d\u0005\u0006'&\u0001\r\u0001V\u0001\bY><w-\u001a:t!\rq\u0013'\u0016\t\u00039YK!aV\u000f\u0003\r1{wmZ3s\u0001")
public class GatlingTask
implements Task {
    private final TaskDef taskDef;
    private final ClassLoader testClassLoader;
    private final String[] args;
    private final String[] tags;

    public TaskDef taskDef() {
        return this.taskDef;
    }

    public String[] tags() {
        return this.tags;
    }

    public Task[] execute(EventHandler eventHandler, Logger[] loggers) {
        Event event;
        String className = this.taskDef().fullyQualifiedName();
        Class<?> simulationClass = this.testClassLoader.loadClass(className);
        long before = System.nanoTime();
        Tuple2 tuple2 = this.liftedTree1$1(simulationClass, loggers);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int returnCode = tuple2._1$mcI$sp();
        Option exception = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)returnCode), (Object)exception);
        Tuple2 tuple23 = tuple22;
        int returnCode2 = tuple23._1$mcI$sp();
        Option exception2 = (Option)tuple23._2();
        long duration = (System.nanoTime() - before) / 1000L;
        String simulationName = simulationClass.getSimpleName();
        TestSelector selector = new TestSelector(simulationName);
        OptionalThrowable optionalThrowable = (OptionalThrowable)exception2.map((Function1 & Serializable)x$3 -> new OptionalThrowable((Throwable)x$3)).getOrElse((Function0 & Serializable)() -> new OptionalThrowable());
        Fingerprint fingerprint = this.taskDef().fingerprint();
        int n = returnCode2;
        if (StatusCode.Success$.MODULE$.code() == n) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])loggers), (Function1 & Serializable)x$4 -> {
                x$4.info(new StringBuilder(23).append("Simulation ").append(simulationName).append(" successful.").toString());
                return BoxedUnit.UNIT;
            });
            event = new SimulationSuccessful(className, fingerprint, (Selector)selector, optionalThrowable, duration);
        } else if (StatusCode.AssertionsFailed$.MODULE$.code() == n) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])loggers), (Function1 & Serializable)x$5 -> {
                x$5.error(new StringBuilder(19).append("Simulation ").append(simulationName).append(" failed.").toString());
                return BoxedUnit.UNIT;
            });
            event = new SimulationFailed(className, fingerprint, (Selector)selector, optionalThrowable, duration);
        } else if (StatusCode.InvalidArguments$.MODULE$.code() == n) {
            String formattedArgs = Predef$.MODULE$.wrapRefArray((Object[])this.args).mkString("(", "", ")");
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])loggers), (Function1 & Serializable)x$6 -> {
                x$6.error(new StringBuilder(34).append("Provided arguments ").append(formattedArgs).append(" are not valid.").toString());
                return BoxedUnit.UNIT;
            });
            event = new InvalidArguments(className, fingerprint, (Selector)selector, optionalThrowable, duration);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        SimulationSuccessful event2 = event;
        eventHandler.handle((Event)event2);
        return (Task[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Task.class));
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(Class simulationClass$1, Logger[] loggers$1) {
        Tuple2 tuple2;
        try {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)Gatling$.MODULE$.fromSbtTestFramework((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.args), (Object)new String[]{"-l", "sbt"}, ClassTag$.MODULE$.apply(String.class)), simulationClass$1)), (Object)None$.MODULE$);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])loggers$1), (Function1 & Serializable)x$1 -> {
                x$1.error(sw.toString());
                return BoxedUnit.UNIT;
            });
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)StatusCode.AssertionsFailed$.MODULE$.code()), (Object)new Some((Object)e));
        }
        return tuple2;
    }

    public GatlingTask(TaskDef taskDef, ClassLoader testClassLoader, String[] args, String[] remoteArgs) {
        this.taskDef = taskDef;
        this.testClassLoader = testClassLoader;
        this.args = args;
        this.tags = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }
}

