/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.ui.swing.frame;

import io.gatling.commons.util.StringHelper;
import io.gatling.commons.util.StringHelper$;
import io.gatling.recorder.ui.swing.frame.ValidationHelper;
import java.awt.Color;
import java.io.Serializable;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.swing.Component;
import scala.swing.Swing$;
import scala.swing.TextField;
import scala.util.Try$;

public final class ValidationHelper$ {
    public static final ValidationHelper$ MODULE$ = new ValidationHelper$();
    private static Border standardBorder;
    private static MatteBorder errorBorder;
    private static final Range.Inclusive portRange;
    private static final String validPackageNameRegex;
    private static final Map<TextField, ValidationHelper.Validator> validators;
    private static final Map<TextField, Object> status;
    private static final Map<TextField, Object> ignoredStatus;
    private static volatile byte bitmap$0;

    static {
        portRange = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 65536);
        validPackageNameRegex = "^[a-z_\\$][\\w\\$]*(?:\\.[a-z_\\$][\\w\\$]*)*$";
        validators = (Map)Map$.MODULE$.empty();
        status = (Map)Map$.MODULE$.empty();
        ignoredStatus = (Map)Map$.MODULE$.empty();
    }

    private Border standardBorder$lzycompute() {
        ValidationHelper$ validationHelper$ = this;
        synchronized (validationHelper$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                standardBorder = new TextField().border();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return standardBorder;
    }

    private Border standardBorder() {
        return (byte)(bitmap$0 & 1) == 0 ? this.standardBorder$lzycompute() : standardBorder;
    }

    private MatteBorder errorBorder$lzycompute() {
        ValidationHelper$ validationHelper$ = this;
        synchronized (validationHelper$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                errorBorder = Swing$.MODULE$.MatteBorder(2, 2, 2, 2, Color.red);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return errorBorder;
    }

    private MatteBorder errorBorder() {
        return (byte)(bitmap$0 & 2) == 0 ? this.errorBorder$lzycompute() : errorBorder;
    }

    private Range.Inclusive portRange() {
        return portRange;
    }

    public boolean isValidPort(String s) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s))).toOption().exists((Function1)(JFunction1.mcZI.sp & Serializable)x -> MODULE$.portRange().contains(x));
    }

    public boolean isNonEmpty(String s) {
        return StringHelper.RichString$.MODULE$.trimToOption$extension(StringHelper$.MODULE$.RichString(s)).isDefined();
    }

    private String validPackageNameRegex() {
        return validPackageNameRegex;
    }

    public boolean isValidPackageName(String s) {
        return s.isEmpty() || s.matches(this.validPackageNameRegex());
    }

    public boolean isValidSimpleClassName(String s) {
        return this.isNonEmpty(s) && !StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(s), '_') && Character.isJavaIdentifierStart(s.charAt(0)) && !StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(s.substring(1, s.length())), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ValidationHelper$.$anonfun$isValidSimpleClassName$1(BoxesRunTime.unboxToChar((Object)x$1))));
    }

    public void setStandardBorder(Component c) {
        c.border_$eq(this.standardBorder());
    }

    public void setErrorBorder(Component c) {
        c.border_$eq((Border)this.errorBorder());
    }

    private Map<TextField, ValidationHelper.Validator> validators() {
        return validators;
    }

    private Map<TextField, Object> status() {
        return status;
    }

    private Map<TextField, Object> ignoredStatus() {
        return ignoredStatus;
    }

    public void registerValidator(TextField textField, ValidationHelper.Validator validator) {
        this.validators().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)textField), (Object)validator));
    }

    public Map<TextField, Object> updateValidationStatus(TextField field) {
        Option option = this.validators().get((Object)field);
        if (!(option instanceof Some)) {
            throw new IllegalStateException(new StringBuilder(40).append("No validator registered for component : ").append(field).toString());
        }
        Some some = (Some)option;
        ValidationHelper.Validator validator = (ValidationHelper.Validator)some.value();
        boolean isValid = BoxesRunTime.unboxToBoolean((Object)validator.condition().apply((Object)field.text()));
        Function1<Component, BoxedUnit> callback = isValid ? validator.successCallback() : validator.failureCallback();
        callback.apply((Object)field);
        Map map = (Map)this.status().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)BoxesRunTime.boxToBoolean((validator.alwaysValid() || isValid ? 1 : 0) != 0)));
        return map;
    }

    public Map<TextField, Object> ignoreValidation(TextField field, boolean value) {
        Option option = this.validators().get((Object)field);
        if (!(option instanceof Some)) {
            throw new IllegalStateException(new StringBuilder(40).append("No validator registered for component : ").append(field).toString());
        }
        Map map = value ? (Map)this.ignoredStatus().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)BoxesRunTime.boxToBoolean((boolean)true))) : (Map)this.ignoredStatus().$minus$eq((Object)field);
        return map;
    }

    public boolean allValid() {
        this.validators().keys().map((Function1 & Serializable)field -> MODULE$.updateValidationStatus((TextField)field));
        return this.validationStatus();
    }

    public boolean validationStatus() {
        return this.status().forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ValidationHelper$.$anonfun$validationStatus$1(x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$isValidSimpleClassName$1(char x$1) {
        return !Character.isJavaIdentifierPart(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$validationStatus$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TextField field = (TextField)tuple2._1();
        boolean s = tuple2._2$mcZ$sp();
        boolean bl = s || BoxesRunTime.unboxToBoolean((Object)MODULE$.ignoredStatus().getOrElse((Object)field, (Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        return bl;
    }

    private ValidationHelper$() {
    }
}

