/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.scenario;

import io.gatling.http.client.uri.Uri;
import io.gatling.http.fetch.ConcurrentResource;
import io.gatling.http.fetch.HtmlParser;
import io.gatling.http.util.HttpHelper$;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.model.HttpRequest;
import io.gatling.recorder.model.HttpResponse;
import io.gatling.recorder.scenario.RequestBody;
import io.gatling.recorder.scenario.RequestBodyBytes;
import io.gatling.recorder.scenario.RequestBodyParams;
import io.gatling.recorder.scenario.RequestElement;
import io.gatling.recorder.scenario.ResponseBody;
import io.gatling.recorder.scenario.ResponseBodyBytes;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.AsciiString;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple9;
import scala.collection.ArrayOps$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class RequestElement$
implements Serializable {
    public static final RequestElement$ MODULE$ = new RequestElement$();
    private static final Set<String> CacheHeaders = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HttpHeaderNames.CACHE_CONTROL.toString(), HttpHeaderNames.IF_MATCH.toString(), HttpHeaderNames.IF_MODIFIED_SINCE.toString(), HttpHeaderNames.IF_NONE_MATCH.toString(), HttpHeaderNames.IF_RANGE.toString(), HttpHeaderNames.IF_UNMODIFIED_SINCE.toString()}));
    private static final Regex io$gatling$recorder$scenario$RequestElement$$HtmlContentType = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?i)text/html\\s*;\\s+charset=\"?([\\w\\-]+)\"?"));

    private Set<String> CacheHeaders() {
        return CacheHeaders;
    }

    public Regex io$gatling$recorder$scenario$RequestElement$$HtmlContentType() {
        return io$gatling$recorder$scenario$RequestElement$$HtmlContentType;
    }

    public Option<String> extractCharsetFromContentType(String contentType) {
        None$ none$;
        Option option;
        String string = contentType;
        if (string != null && !(option = this.io$gatling$recorder$scenario$RequestElement$$HtmlContentType().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String charset = (String)((LinearSeqOps)option.get()).apply(0);
            none$ = new Some((Object)charset);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public RequestElement apply(HttpRequest request, HttpResponse response, RecorderConfiguration configuration) {
        HttpHeaders httpHeaders;
        boolean formUrlEncoded;
        HttpHeaders requestHeaders = request.headers();
        None$ requestBody = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.byteArrayOps(request.body())) ? ((formUrlEncoded = Option$.MODULE$.apply((Object)requestHeaders.get((CharSequence)HttpHeaderNames.CONTENT_TYPE)).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RequestElement$.$anonfun$apply$1(x$1)))) ? new Some((Object)new RequestBodyParams((List<Tuple2<String, String>>)HttpHelper$.MODULE$.parseFormBody(new String(request.body(), StandardCharsets.UTF_8.name())))) : new Some((Object)new RequestBodyBytes(request.body()))) : None$.MODULE$;
        None$ responseBody = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.byteArrayOps(response.body())) ? new Some((Object)new ResponseBodyBytes(response.body())) : None$.MODULE$;
        List embeddedResources = (List)Option$.MODULE$.apply((Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)).collect((PartialFunction)new Serializable((Option)responseBody, response, request){
            private static final long serialVersionUID = 0L;
            private final Option responseBody$1;
            private final HttpResponse response$1;
            private final HttpRequest request$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Option option;
                A1 A1 = x1;
                if (A1 != null && !(option = RequestElement$.MODULE$.io$gatling$recorder$scenario$RequestElement$$HtmlContentType().unapplySeq(A1)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                    String headerCharset = (String)((LinearSeqOps)option.get()).apply(0);
                    if (this.responseBody$1.nonEmpty()) {
                        Charset charset = (Charset)Option$.MODULE$.apply((Object)headerCharset).flatMap((Function1 & Serializable)contentType -> RequestElement$.MODULE$.extractCharsetFromContentType((String)contentType)).collect((PartialFunction)new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                Object object = Charset.isSupported(A1) ? Charset.forName(A1) : function1.apply(x1);
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(String x1) {
                                String string = x1;
                                boolean bl = Charset.isSupported(string);
                                return bl;
                            }
                        }).getOrElse((Function0 & Serializable)() -> StandardCharsets.UTF_8);
                        char[] htmlChars = new String(this.response$1.body(), charset).toCharArray();
                        object = new HtmlParser().getEmbeddedResources(Uri.create((String)this.request$1.uri()), htmlChars);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                Option option;
                String string = x1;
                boolean bl = string != null && !(option = RequestElement$.MODULE$.io$gatling$recorder$scenario$RequestElement$$HtmlContentType().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0 && this.responseBody$1.nonEmpty();
                return bl;
            }
            {
                this.responseBody$1 = responseBody$1;
                this.response$1 = response$1;
                this.request$1 = request$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.String ), $anonfun$applyOrElse$2()}, serializedLambda);
            }
        }).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil());
        if (configuration.http().removeCacheHeaders()) {
            DefaultHttpHeaders filtered = new DefaultHttpHeaders(false);
            CollectionConverters$.MODULE$.ListHasAsScala(requestHeaders.entries()).asScala().withFilter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)RequestElement$.$anonfun$apply$3(entry))).foreach((Function1 & Serializable)entry -> filtered.add((String)entry.getKey(), entry.getValue()));
            httpHeaders = filtered;
        } else {
            httpHeaders = requestHeaders;
        }
        HttpHeaders filteredRequestHeaders = httpHeaders;
        return new RequestElement(request.uri(), request.method(), filteredRequestHeaders, (Option<RequestBody>)requestBody, response.headers(), (Option<ResponseBody>)responseBody, response.status(), (List<ConcurrentResource>)embeddedResources, (List<RequestElement>)package$.MODULE$.Nil());
    }

    public RequestElement apply(String uri, String method, HttpHeaders headers, Option<RequestBody> body, HttpHeaders responseHeaders, Option<ResponseBody> responseBody, int statusCode, List<ConcurrentResource> embeddedResources, List<RequestElement> nonEmbeddedResources) {
        return new RequestElement(uri, method, headers, body, responseHeaders, responseBody, statusCode, embeddedResources, nonEmbeddedResources);
    }

    public Option<Tuple9<String, String, HttpHeaders, Option<RequestBody>, HttpHeaders, Option<ResponseBody>, Object, List<ConcurrentResource>, List<RequestElement>>> unapply(RequestElement x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple9((Object)x$0.uri(), (Object)x$0.method(), (Object)x$0.headers(), x$0.body(), (Object)x$0.responseHeaders(), x$0.responseBody(), (Object)BoxesRunTime.boxToInteger((int)x$0.statusCode()), x$0.embeddedResources(), x$0.nonEmbeddedResources()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RequestElement$.class);
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(String x$1) {
        return AsciiString.contains((CharSequence)x$1, (CharSequence)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(Map.Entry entry) {
        return !MODULE$.CacheHeaders().contains(entry.getKey());
    }

    private RequestElement$() {
    }
}

