/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.mitm;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.netty.util.ByteBufUtils;
import io.gatling.recorder.controller.RecorderController;
import io.gatling.recorder.http.Remote;
import io.gatling.recorder.model.HttpRequest;
import io.gatling.recorder.model.HttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelId;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005i4Q\u0001C\u0005\u0003\u0013MA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006W\u0001!\t\u0001\f\u0005\ba\u0001\u0011\r\u0011\"\u00032\u0011\u0019Q\u0005\u0001)A\u0005e!)1\n\u0001C\u0001\u0019\")Q\u000e\u0001C\u0001]\")q\u000f\u0001C\u0001q\niAK]1gM&\u001cGj\\4hKJT!AC\u0006\u0002\t5LG/\u001c\u0006\u0003\u00195\tA\u0001\u001b;ua*\u0011abD\u0001\te\u0016\u001cwN\u001d3fe*\u0011\u0001#E\u0001\bO\u0006$H.\u001b8h\u0015\u0005\u0011\u0012AA5p'\r\u0001AC\u0007\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005m\u0011S\"\u0001\u000f\u000b\u0005uq\u0012\u0001D:dC2\fGn\\4hS:<'BA\u0010!\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0011\u0002\u0007\r|W.\u0003\u0002$9\ti1\u000b\u001e:jGRdunZ4j]\u001e\f!bY8oiJ|G\u000e\\3s\u0007\u0001\u0001\"aJ\u0015\u000e\u0003!R!\u0001J\u0007\n\u0005)B#A\u0005*fG>\u0014H-\u001a:D_:$(o\u001c7mKJ\fa\u0001P5oSRtDCA\u00170!\tq\u0003!D\u0001\n\u0011\u0015!#\u00011\u0001'\u000391G._5oOJ+\u0017/^3tiN,\u0012A\r\t\u0005gibD)D\u00015\u0015\t)d'\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u000e\u001d\u0002\tU$\u0018\u000e\u001c\u0006\u0002s\u0005!!.\u0019<b\u0013\tYDGA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\u000f\rD\u0017M\u001c8fY*\u0011\u0011)E\u0001\u0006]\u0016$H/_\u0005\u0003\u0007z\u0012\u0011b\u00115b]:,G.\u00133\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001dk\u0011!B7pI\u0016d\u0017BA%G\u0005-AE\u000f\u001e9SKF,Xm\u001d;\u0002\u001f\u0019d\u00170\u001b8h%\u0016\fX/Z:ug\u0002\n!\u0002\\8h%\u0016\fX/Z:u)\u0019i\u0005KU/dQB\u0011QCT\u0005\u0003\u001fZ\u0011A!\u00168ji\")\u0011+\u0002a\u0001y\u0005y1/\u001a:wKJ\u001c\u0005.\u00198oK2LE\rC\u0003T\u000b\u0001\u0007A+A\u0004sKF,Xm\u001d;\u0011\u0005U[V\"\u0001,\u000b\u000519&B\u0001-Z\u0003\u0015\u0019w\u000eZ3d\u0015\tQ\u0006)A\u0004iC:$G.\u001a:\n\u0005q3&a\u0004$vY2DE\u000f\u001e9SKF,Xm\u001d;\t\u000by+\u0001\u0019A0\u0002\rI,Wn\u001c;f!\t\u0001\u0017-D\u0001\f\u0013\t\u00117B\u0001\u0004SK6|G/\u001a\u0005\u0006I\u0016\u0001\r!Z\u0001\u0006QR$\bo\u001d\t\u0003+\u0019L!a\u001a\f\u0003\u000f\t{w\u000e\\3b]\")\u0011.\u0002a\u0001U\u0006i1/\u001a8e)&lWm\u001d;b[B\u0004\"!F6\n\u000514\"\u0001\u0002'p]\u001e\f1\u0002\\8h%\u0016\u001c\bo\u001c8tKR!Qj\u001c9v\u0011\u0015\tf\u00011\u0001=\u0011\u0015\th\u00011\u0001s\u0003!\u0011Xm\u001d9p]N,\u0007CA+t\u0013\t!hK\u0001\tGk2d\u0007\n\u001e;q%\u0016\u001c\bo\u001c8tK\")aO\u0002a\u0001U\u0006\u0001\"/Z2fSZ,G+[7fgR\fW\u000e]\u0001\u0006G2,\u0017M\u001d\u000b\u0003\u001bfDQ!U\u0004A\u0002q\u0002")
public final class TrafficLogger
implements StrictLogging {
    private final RecorderController controller;
    private final ConcurrentHashMap<ChannelId, HttpRequest> flyingRequests;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ConcurrentHashMap<ChannelId, HttpRequest> flyingRequests() {
        return this.flyingRequests;
    }

    public void logRequest(ChannelId serverChannelId, FullHttpRequest request, Remote remote, boolean https, long sendTimestamp) {
        HttpMethod httpMethod = request.method();
        HttpMethod httpMethod2 = HttpMethod.CONNECT;
        if ((httpMethod == null ? httpMethod2 != null : !httpMethod.equals(httpMethod2)) && !request.headers().contains((CharSequence)HttpHeaderValues.UPGRADE)) {
            HttpRequest requestEvent = new HttpRequest(request.protocolVersion().text(), request.method().name(), remote.makeAbsoluteUri(request.uri(), https), new DefaultHttpHeaders().add(request.headers()).add(request.trailingHeaders()), ByteBufUtils.byteBuf2Bytes((ByteBuf)request.content()), sendTimestamp);
            this.flyingRequests().put(serverChannelId, requestEvent);
            return;
        }
    }

    public void logResponse(ChannelId serverChannelId, FullHttpResponse response, long receiveTimestamp) {
        Option$.MODULE$.apply((Object)this.flyingRequests().get(serverChannelId)).foreach((Function1 & Serializable)requestEvent -> {
            TrafficLogger.$anonfun$logResponse$1(this, serverChannelId, response, receiveTimestamp, requestEvent);
            return BoxedUnit.UNIT;
        });
    }

    public void clear(ChannelId serverChannelId) {
        this.flyingRequests().remove(serverChannelId);
    }

    public static final /* synthetic */ void $anonfun$logResponse$1(TrafficLogger $this, ChannelId serverChannelId$1, FullHttpResponse response$1, long receiveTimestamp$1, HttpRequest requestEvent) {
        $this.flyingRequests().remove(serverChannelId$1);
        HttpResponse responseEvent = new HttpResponse(response$1.status().code(), response$1.status().reasonPhrase(), new DefaultHttpHeaders().add(response$1.headers()).add(response$1.trailingHeaders()), ByteBufUtils.byteBuf2Bytes((ByteBuf)response$1.content()), receiveTimestamp$1);
        $this.controller.receiveResponse(requestEvent, responseEvent);
    }

    public TrafficLogger(RecorderController controller) {
        this.controller = controller;
        StrictLogging.$init$((StrictLogging)this);
        this.flyingRequests = new ConcurrentHashMap();
        Statics.releaseFence();
    }
}

