/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http.mitm;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.model.Credentials;
import io.gatling.commons.util.Clock;
import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.controller.RecorderController;
import io.gatling.recorder.http.OutgoingProxy;
import io.gatling.recorder.http.mitm.Mitm;
import io.gatling.recorder.http.mitm.Mitm$HandlerName$;
import io.gatling.recorder.http.mitm.ServerHandler;
import io.gatling.recorder.http.mitm.TrafficLogger;
import io.gatling.recorder.http.ssl.SslServerContext;
import io.gatling.recorder.http.ssl.SslServerContext$;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Mitm$
implements StrictLogging {
    public static final Mitm$ MODULE$ = new Mitm$();
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public Mitm apply(RecorderController controller, Clock clock, RecorderConfiguration config) {
        DefaultChannelGroup serverChannelGroup = new DefaultChannelGroup("Gatling_Recorder", (EventExecutor)GlobalEventExecutor.INSTANCE);
        NioEventLoopGroup bindEventLoopGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup socketEventLoopGroup = new NioEventLoopGroup();
        TrafficLogger trafficLogger = new TrafficLogger(controller);
        SslServerContext sslServerContext = SslServerContext$.MODULE$.apply(config);
        Function0 & Serializable httpClientCodecFactory = (Function0 & Serializable)() -> new HttpClientCodec(10000, 20000, 8192);
        Option outgoingProxy = config.proxy().outgoing().host().map((Function1 & Serializable)proxyHost -> {
            int port = BoxesRunTime.unboxToInt((Object)config.proxy().outgoing().port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 80));
            int securedPort = BoxesRunTime.unboxToInt((Object)config.proxy().outgoing().sslPort().orElse((Function0 & Serializable)() -> config.proxy().outgoing().port()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 443));
            Option credentials = config.proxy().outgoing().username().flatMap((Function1 & Serializable)username -> config.proxy().outgoing().password().map((Function1 & Serializable)password -> new Credentials(username, password)));
            return new OutgoingProxy((String)proxyHost, port, securedPort, (Option<Credentials>)credentials);
        });
        Bootstrap clientBootstrap = (Bootstrap)new Bootstrap().channel(NioSocketChannel.class).option(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE).handler((ChannelHandler)new ChannelInitializer<Channel>((Function0)httpClientCodecFactory){
            private final Function0 httpClientCodecFactory$1;

            public void initChannel(Channel ch) {
                BoxedUnit boxedUnit;
                if (Mitm$.MODULE$.logger().underlying().isDebugEnabled()) {
                    Mitm$.MODULE$.logger().underlying().debug("Open new client channel");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                ch.pipeline().addLast(Mitm$HandlerName$.MODULE$.HttpCodec(), (ChannelHandler)this.httpClientCodecFactory$1.apply()).addLast("contentDecompressor", (ChannelHandler)new HttpContentDecompressor()).addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE));
            }
            {
                this.httpClientCodecFactory$1 = httpClientCodecFactory$1;
            }
        });
        ServerBootstrap serverBootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().option(ChannelOption.SO_BACKLOG, (Object)1024)).group((EventLoopGroup)bindEventLoopGroup, (EventLoopGroup)socketEventLoopGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(outgoingProxy, clientBootstrap, sslServerContext, trafficLogger, (Function0)httpClientCodecFactory, clock){
            private final Option outgoingProxy$1;
            private final Bootstrap clientBootstrap$1;
            private final SslServerContext sslServerContext$1;
            private final TrafficLogger trafficLogger$1;
            private final Function0 httpClientCodecFactory$1;
            private final Clock clock$1;

            public void initChannel(Channel ch) {
                BoxedUnit boxedUnit;
                if (Mitm$.MODULE$.logger().underlying().isDebugEnabled()) {
                    Mitm$.MODULE$.logger().underlying().debug("Open new server channel");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                ch.pipeline().addLast("requestDecoder", (ChannelHandler)new HttpRequestDecoder(10000, 20000, 8192)).addLast("contentDecompressor", (ChannelHandler)new HttpContentDecompressor()).addLast("responseEncoder", (ChannelHandler)new HttpResponseEncoder()).addLast("contentCompressor", (ChannelHandler)new HttpContentCompressor()).addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE)).addLast(Mitm$HandlerName$.MODULE$.RecorderServer(), (ChannelHandler)new ServerHandler((Option<OutgoingProxy>)this.outgoingProxy$1, this.clientBootstrap$1, this.sslServerContext$1, this.trafficLogger$1, (Function0<HttpClientCodec>)this.httpClientCodecFactory$1, this.clock$1));
            }
            {
                this.outgoingProxy$1 = outgoingProxy$1;
                this.clientBootstrap$1 = clientBootstrap$1;
                this.sslServerContext$1 = sslServerContext$1;
                this.trafficLogger$1 = trafficLogger$1;
                this.httpClientCodecFactory$1 = httpClientCodecFactory$1;
                this.clock$1 = clock$1;
            }
        });
        serverChannelGroup.add(serverBootstrap.bind((SocketAddress)new InetSocketAddress(config.proxy().port())).sync().channel());
        return new Mitm((ChannelGroup)serverChannelGroup, (EventLoopGroup)bindEventLoopGroup, (EventLoopGroup)socketEventLoopGroup);
    }

    private Mitm$() {
    }
}

