/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.jcajce.provider.asymmetric.util;

import io.gatling.recorder.internal.bouncycastle.crypto.CipherParameters;
import io.gatling.recorder.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.gatling.recorder.internal.bouncycastle.crypto.params.ParametersWithContext;
import io.gatling.recorder.internal.bouncycastle.crypto.params.ParametersWithRandom;
import io.gatling.recorder.internal.bouncycastle.jcajce.spec.ContextParameterSpec;
import io.gatling.recorder.internal.bouncycastle.jcajce.util.BCJcaJceHelper;
import io.gatling.recorder.internal.bouncycastle.jcajce.util.JcaJceHelper;
import io.gatling.recorder.internal.bouncycastle.util.Exceptions;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public abstract class BaseDeterministicOrRandomSignature
extends Signature {
    private final JcaJceHelper helper = new BCJcaJceHelper();
    private final AlgorithmParameterSpec originalSpec = ContextParameterSpec.EMPTY_CONTEXT_SPEC;
    protected AlgorithmParameters engineParams;
    protected ContextParameterSpec paramSpec;
    protected AsymmetricKeyParameter keyParams;
    protected boolean isInitState = true;

    protected BaseDeterministicOrRandomSignature(String string) {
        super(string);
    }

    @Override
    protected final void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.verifyInit(publicKey);
        this.paramSpec = ContextParameterSpec.EMPTY_CONTEXT_SPEC;
        this.isInitState = true;
        this.reInit();
    }

    protected abstract void verifyInit(PublicKey var1) throws InvalidKeyException;

    @Override
    protected final void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.signInit(privateKey, null);
        this.paramSpec = ContextParameterSpec.EMPTY_CONTEXT_SPEC;
        this.isInitState = true;
        this.reInit();
    }

    @Override
    protected final void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.signInit(privateKey, secureRandom);
        this.paramSpec = ContextParameterSpec.EMPTY_CONTEXT_SPEC;
        this.isInitState = true;
        this.reInit();
    }

    protected abstract void signInit(PrivateKey var1, SecureRandom var2) throws InvalidKeyException;

    @Override
    protected final void engineUpdate(byte by) throws SignatureException {
        this.isInitState = false;
        this.updateEngine(by);
    }

    protected abstract void updateEngine(byte var1) throws SignatureException;

    @Override
    protected final void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.isInitState = false;
        this.updateEngine(byArray, n, n2);
    }

    protected abstract void updateEngine(byte[] var1, int var2, int var3) throws SignatureException;

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            if (this.originalSpec != null) {
                algorithmParameterSpec = this.originalSpec;
            } else {
                return;
            }
        }
        if (!this.isInitState) {
            throw new ProviderException("cannot call setParameter in the middle of update");
        }
        if (!(algorithmParameterSpec instanceof ContextParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unknown AlgorithmParameterSpec in signature");
        }
        this.paramSpec = (ContextParameterSpec)algorithmParameterSpec;
        this.reInit();
    }

    private void reInit() {
        CipherParameters cipherParameters = this.keyParams;
        if (this.keyParams.isPrivate()) {
            if (this.appRandom != null) {
                cipherParameters = new ParametersWithRandom(cipherParameters, this.appRandom);
            }
            if (this.paramSpec != null) {
                cipherParameters = new ParametersWithContext(cipherParameters, this.paramSpec.getContext());
            }
            this.reInitialize(true, cipherParameters);
        } else {
            if (this.paramSpec != null) {
                cipherParameters = new ParametersWithContext(cipherParameters, this.paramSpec.getContext());
            }
            this.reInitialize(false, cipherParameters);
        }
    }

    protected abstract void reInitialize(boolean var1, CipherParameters var2);

    @Override
    protected final AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null && this.paramSpec != ContextParameterSpec.EMPTY_CONTEXT_SPEC) {
            try {
                this.engineParams = this.helper.createAlgorithmParameters("CONTEXT");
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception exception) {
                throw Exceptions.illegalStateException(exception.toString(), exception);
            }
        }
        return this.engineParams;
    }

    @Override
    protected final void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("SetParameter unsupported");
    }

    @Override
    protected final Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("GetParameter unsupported");
    }
}

