/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.crypto.kems;

import io.gatling.recorder.internal.bouncycastle.crypto.Digest;
import io.gatling.recorder.internal.bouncycastle.crypto.EncapsulatedSecretGenerator;
import io.gatling.recorder.internal.bouncycastle.crypto.SecretWithEncapsulation;
import io.gatling.recorder.internal.bouncycastle.crypto.kems.SAKKEKEMExtractor;
import io.gatling.recorder.internal.bouncycastle.crypto.kems.SecretWithEncapsulationImpl;
import io.gatling.recorder.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.gatling.recorder.internal.bouncycastle.crypto.params.SAKKEPublicKeyParameters;
import io.gatling.recorder.internal.bouncycastle.math.ec.ECCurve;
import io.gatling.recorder.internal.bouncycastle.math.ec.ECPoint;
import io.gatling.recorder.internal.bouncycastle.util.Arrays;
import io.gatling.recorder.internal.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SAKKEKEMSGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom random;

    public SAKKEKEMSGenerator(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        SAKKEPublicKeyParameters sAKKEPublicKeyParameters = (SAKKEPublicKeyParameters)asymmetricKeyParameter;
        ECPoint eCPoint = sAKKEPublicKeyParameters.getZ();
        BigInteger bigInteger = sAKKEPublicKeyParameters.getIdentifier();
        BigInteger bigInteger2 = sAKKEPublicKeyParameters.getPrime();
        BigInteger bigInteger3 = sAKKEPublicKeyParameters.getQ();
        BigInteger bigInteger4 = sAKKEPublicKeyParameters.getG();
        int n = sAKKEPublicKeyParameters.getN();
        ECCurve eCCurve = sAKKEPublicKeyParameters.getCurve();
        ECPoint eCPoint2 = sAKKEPublicKeyParameters.getPoint();
        Digest digest = sAKKEPublicKeyParameters.getDigest();
        BigInteger bigInteger5 = BigIntegers.createRandomBigInteger(n, this.random);
        BigInteger bigInteger6 = SAKKEKEMSGenerator.hashToIntegerRange(Arrays.concatenate(bigInteger5.toByteArray(), bigInteger.toByteArray()), bigInteger3, digest);
        ECPoint eCPoint3 = eCPoint2.multiply(bigInteger).normalize();
        ECPoint eCPoint4 = eCPoint3.add(eCPoint).multiply(bigInteger6).normalize();
        BigInteger bigInteger7 = BigInteger.ONE;
        BigInteger bigInteger8 = bigInteger4;
        BigInteger[] bigIntegerArray = new BigInteger[2];
        BigInteger bigInteger9 = BigInteger.ONE;
        BigInteger bigInteger10 = bigInteger4;
        ECPoint eCPoint5 = eCCurve.createPoint(bigInteger9, bigInteger10);
        int n2 = bigInteger6.bitLength();
        for (int i = n2 - 2; i >= 0; --i) {
            BigInteger[] bigIntegerArray2 = SAKKEKEMExtractor.fp2PointSquare(bigInteger9, bigInteger10, bigInteger2);
            eCPoint5 = eCPoint5.timesPow2(2);
            bigInteger9 = bigIntegerArray2[0];
            bigInteger10 = bigIntegerArray2[1];
            if (!bigInteger6.testBit(i)) continue;
            bigIntegerArray2 = SAKKEKEMExtractor.fp2Multiply(bigInteger9, bigInteger10, bigInteger7, bigInteger8, bigInteger2);
            bigInteger9 = bigIntegerArray2[0];
            bigInteger10 = bigIntegerArray2[1];
        }
        bigIntegerArray[0] = bigInteger9;
        bigIntegerArray[1] = bigInteger10;
        BigInteger bigInteger11 = bigIntegerArray[1].multiply(bigIntegerArray[0].modInverse(bigInteger2)).mod(bigInteger2);
        BigInteger bigInteger12 = SAKKEKEMSGenerator.hashToIntegerRange(bigInteger11.toByteArray(), BigInteger.ONE.shiftLeft(n), digest);
        BigInteger bigInteger13 = bigInteger5.xor(bigInteger12);
        byte[] byArray = Arrays.concatenate(eCPoint4.getEncoded(false), BigIntegers.asUnsignedByteArray(16, bigInteger13));
        return new SecretWithEncapsulationImpl(BigIntegers.asUnsignedByteArray(n / 8, bigInteger5), byArray);
    }

    static BigInteger hashToIntegerRange(byte[] byArray, BigInteger bigInteger, Digest digest) {
        byte[] byArray2 = new byte[digest.getDigestSize()];
        digest.update(byArray, 0, byArray.length);
        digest.doFinal(byArray2, 0);
        byte[] byArray3 = Arrays.clone(byArray2);
        byte[] byArray4 = new byte[digest.getDigestSize()];
        int n = bigInteger.bitLength() >> 8;
        BigInteger bigInteger2 = BigInteger.ZERO;
        for (int i = 0; i <= n; ++i) {
            digest.update(byArray4, 0, byArray4.length);
            digest.doFinal(byArray4, 0);
            digest.update(byArray4, 0, byArray4.length);
            digest.update(byArray3, 0, byArray3.length);
            byte[] byArray5 = new byte[digest.getDigestSize()];
            digest.doFinal(byArray5, 0);
            bigInteger2 = bigInteger2.shiftLeft(byArray5.length * 8).add(new BigInteger(1, byArray5));
        }
        return bigInteger2.mod(bigInteger);
    }
}

