/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.crypto.mlkem;

import io.gatling.recorder.internal.bouncycastle.crypto.EncapsulatedSecretGenerator;
import io.gatling.recorder.internal.bouncycastle.crypto.SecretWithEncapsulation;
import io.gatling.recorder.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.mlkem.MLKEMEngine;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import java.security.SecureRandom;

public class MLKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public MLKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        MLKEMPublicKeyParameters mLKEMPublicKeyParameters = (MLKEMPublicKeyParameters)asymmetricKeyParameter;
        MLKEMEngine mLKEMEngine = mLKEMPublicKeyParameters.getParameters().getEngine();
        mLKEMEngine.init(this.sr);
        byte[] byArray = new byte[32];
        mLKEMEngine.getRandomBytes(byArray);
        byte[][] byArray2 = mLKEMEngine.kemEncrypt(mLKEMPublicKeyParameters.getEncoded(), byArray);
        return new SecretWithEncapsulationImpl(byArray2[0], byArray2[1]);
    }

    public SecretWithEncapsulation internalGenerateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) {
        MLKEMPublicKeyParameters mLKEMPublicKeyParameters = (MLKEMPublicKeyParameters)asymmetricKeyParameter;
        MLKEMEngine mLKEMEngine = mLKEMPublicKeyParameters.getParameters().getEngine();
        mLKEMEngine.init(this.sr);
        byte[][] byArray2 = mLKEMEngine.kemEncryptInternal(mLKEMPublicKeyParameters.getEncoded(), byArray);
        return new SecretWithEncapsulationImpl(byArray2[0], byArray2[1]);
    }
}

