/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.kyber;

import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Set;
import io.gatling.recorder.internal.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.interfaces.KyberPrivateKey;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.interfaces.KyberPublicKey;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.kyber.BCKyberPublicKey;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.spec.KyberParameterSpec;
import io.gatling.recorder.internal.bouncycastle.util.Arrays;
import io.gatling.recorder.internal.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BCKyberPrivateKey
implements KyberPrivateKey {
    private static final long serialVersionUID = 1L;
    private transient KyberPrivateKeyParameters params;
    private transient String algorithm;
    private transient ASN1Set attributes;

    public BCKyberPrivateKey(KyberPrivateKeyParameters kyberPrivateKeyParameters) {
        this.params = kyberPrivateKeyParameters;
        this.algorithm = Strings.toUpperCase(kyberPrivateKeyParameters.getParameters().getName());
    }

    public BCKyberPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (KyberPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
        this.algorithm = Strings.toUpperCase(this.params.getParameters().getName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCKyberPrivateKey) {
            BCKyberPrivateKey bCKyberPrivateKey = (BCKyberPrivateKey)object;
            return Arrays.areEqual(this.getEncoded(), bCKyberPrivateKey.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public KyberPublicKey getPublicKey() {
        return new BCKyberPublicKey(this.params.getPublicKeyParameters());
    }

    @Override
    public KyberParameterSpec getParameterSpec() {
        return KyberParameterSpec.fromName(this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    KyberPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

