package io.gatling.recorder.internal.bouncycastle.cert.ocsp.jcajce;

import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

import io.gatling.recorder.internal.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import io.gatling.recorder.internal.bouncycastle.cert.ocsp.CertificateID;
import io.gatling.recorder.internal.bouncycastle.cert.ocsp.OCSPException;
import io.gatling.recorder.internal.bouncycastle.operator.DigestCalculator;

public class JcaCertificateID
    extends CertificateID
{
    public JcaCertificateID(DigestCalculator digestCalculator, X509Certificate issuerCert, BigInteger number)
        throws OCSPException, CertificateEncodingException
    {
        super(digestCalculator, new JcaX509CertificateHolder(issuerCert), number);
    }
}
