/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.crypto.picnic;

import io.gatling.recorder.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import io.gatling.recorder.internal.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import io.gatling.recorder.internal.bouncycastle.crypto.KeyGenerationParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.picnic.PicnicEngine;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.picnic.PicnicKeyGenerationParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.picnic.PicnicParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.picnic.PicnicPrivateKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.picnic.PicnicPublicKeyParameters;
import java.security.SecureRandom;

public class PicnicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;
    private PicnicParameters parameters;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        this.parameters = ((PicnicKeyGenerationParameters)keyGenerationParameters).getParameters();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        PicnicEngine picnicEngine = this.parameters.getEngine();
        byte[] byArray = new byte[picnicEngine.getSecretKeySize()];
        byte[] byArray2 = new byte[picnicEngine.getPublicKeySize()];
        picnicEngine.crypto_sign_keypair(byArray2, byArray, this.random);
        PicnicPublicKeyParameters picnicPublicKeyParameters = new PicnicPublicKeyParameters(this.parameters, byArray2);
        PicnicPrivateKeyParameters picnicPrivateKeyParameters = new PicnicPrivateKeyParameters(this.parameters, byArray);
        return new AsymmetricCipherKeyPair(picnicPublicKeyParameters, picnicPrivateKeyParameters);
    }
}

