/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.crypto.hqc;

import io.gatling.recorder.internal.bouncycastle.crypto.EncapsulatedSecretGenerator;
import io.gatling.recorder.internal.bouncycastle.crypto.SecretWithEncapsulation;
import io.gatling.recorder.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.hqc.HQCEngine;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.hqc.HQCPublicKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import io.gatling.recorder.internal.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class HQCKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public HQCKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        HQCPublicKeyParameters hQCPublicKeyParameters = (HQCPublicKeyParameters)asymmetricKeyParameter;
        HQCEngine hQCEngine = hQCPublicKeyParameters.getParameters().getEngine();
        byte[] byArray = new byte[hQCPublicKeyParameters.getParameters().getSHA512_BYTES()];
        byte[] byArray2 = new byte[hQCPublicKeyParameters.getParameters().getN_BYTES()];
        byte[] byArray3 = new byte[hQCPublicKeyParameters.getParameters().getN1N2_BYTES()];
        byte[] byArray4 = new byte[hQCPublicKeyParameters.getParameters().getSHA512_BYTES()];
        byte[] byArray5 = hQCPublicKeyParameters.getPublicKey();
        byte[] byArray6 = new byte[48];
        this.sr.nextBytes(byArray6);
        hQCEngine.encaps(byArray2, byArray3, byArray, byArray4, byArray5, byArray6);
        byte[] byArray7 = Arrays.concatenate(byArray2, byArray3);
        byArray7 = Arrays.concatenate(byArray7, byArray4);
        return new SecretWithEncapsulationImpl(Arrays.copyOfRange(byArray, 0, hQCPublicKeyParameters.getParameters().getK()), byArray7);
    }
}

