/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.mime.smime;

import io.gatling.recorder.internal.bouncycastle.mime.BasicMimeParser;
import io.gatling.recorder.internal.bouncycastle.mime.Headers;
import io.gatling.recorder.internal.bouncycastle.mime.MimeParser;
import io.gatling.recorder.internal.bouncycastle.mime.MimeParserProvider;
import io.gatling.recorder.internal.bouncycastle.mime.smime.SMimeParserContext;
import io.gatling.recorder.internal.bouncycastle.mime.smime.SMimeUtils;
import io.gatling.recorder.internal.bouncycastle.operator.DigestCalculatorProvider;
import java.io.IOException;
import java.io.InputStream;

public class SMimeParserProvider
implements MimeParserProvider {
    private final String defaultContentTransferEncoding;
    private final DigestCalculatorProvider digestCalculatorProvider;

    public SMimeParserProvider(String string, DigestCalculatorProvider digestCalculatorProvider) {
        this.defaultContentTransferEncoding = string;
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    @Override
    public MimeParser createParser(InputStream inputStream) throws IOException {
        return new BasicMimeParser(new SMimeParserContext(this.defaultContentTransferEncoding, this.digestCalculatorProvider), SMimeUtils.autoBuffer(inputStream));
    }

    @Override
    public MimeParser createParser(Headers headers, InputStream inputStream) throws IOException {
        return new BasicMimeParser(new SMimeParserContext(this.defaultContentTransferEncoding, this.digestCalculatorProvider), headers, SMimeUtils.autoBuffer(inputStream));
    }
}

