/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.netty.util;

import io.gatling.netty.util.StringBuilderPool;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.util.List;

public class StringWithCachedBytes {
    public final String string;
    public final byte[] bytes;

    public static ByteBuf toByteBuf(List<StringWithCachedBytes> list) {
        switch (list.size()) {
            case 0: {
                return Unpooled.EMPTY_BUFFER;
            }
            case 1: {
                return Unpooled.wrappedBuffer((byte[])list.get((int)0).bytes);
            }
        }
        CompositeByteBuf compositeByteBuf = new CompositeByteBuf(ByteBufAllocator.DEFAULT, false, list.size());
        for (StringWithCachedBytes stringWithCachedBytes : list) {
            compositeByteBuf.addComponent(true, Unpooled.wrappedBuffer((byte[])stringWithCachedBytes.bytes));
        }
        return compositeByteBuf;
    }

    public static String toString(List<StringWithCachedBytes> list) {
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
        for (StringWithCachedBytes stringWithCachedBytes : list) {
            stringBuilder.append(stringWithCachedBytes.string);
        }
        return stringBuilder.toString();
    }

    public StringWithCachedBytes(String string, Charset charset) {
        this.string = string;
        this.bytes = string.getBytes(charset);
    }

    public String toString() {
        return this.string;
    }
}

