/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.mqtt.internal;

import io.gatling.core.check.Check;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.internal.CoreCheckType;
import io.gatling.mqtt.Predef$;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.List;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;

public final class MqttChecks$ {
    public static final MqttChecks$ MODULE$ = new MqttChecks$();

    private Check<ByteBuf> toScalaCheck(CheckBuilder javaCheck) {
        Check check;
        io.gatling.core.check.CheckBuilder scalaCheck = javaCheck.asScala();
        CheckBuilder.CheckType checkType = javaCheck.type();
        if (CoreCheckType.BodyBytes.equals(checkType)) {
            check = scalaCheck.build(Predef$.MODULE$.MqttBufferBodyBytesCorrelatorMaterializer());
        } else if (CoreCheckType.BodyLength.equals(checkType)) {
            check = scalaCheck.build(Predef$.MODULE$.MqttBufferBodyLengthCorrelatorMaterializer());
        } else if (CoreCheckType.BodyString.equals(checkType)) {
            check = scalaCheck.build(Predef$.MODULE$.MqttBufferBodyStringCorrelatorMaterializer());
        } else if (CoreCheckType.Substring.equals(checkType)) {
            check = scalaCheck.build(Predef$.MODULE$.MqttBufferSubstringCorrelatorMaterializer());
        } else if (CoreCheckType.Regex.equals(checkType)) {
            check = scalaCheck.build(Predef$.MODULE$.MqttBufferRegexCorrelatorMaterializer());
        } else if (CoreCheckType.JsonPath.equals(checkType)) {
            check = scalaCheck.build(Predef$.MODULE$.mqttBufferJsonPathMaterializer(io.gatling.core.Predef$.MODULE$.defaultJsonParsers()));
        } else if (CoreCheckType.JmesPath.equals(checkType)) {
            check = scalaCheck.build(Predef$.MODULE$.mqttBufferJmesPathMaterializer(io.gatling.core.Predef$.MODULE$.defaultJsonParsers()));
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("MQTT DSL doesn't support ").append(checkType).toString());
        }
        return check;
    }

    public Seq<Check<ByteBuf>> toScalaChecks(List<CheckBuilder> javaChecks) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(javaChecks).asScala().map((Function1 & Serializable)javaCheck -> MODULE$.toScalaCheck((CheckBuilder)javaCheck))).toSeq();
    }

    private MqttChecks$() {
    }
}

