/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.mqtt;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.javaapi.core.ActionBuilder;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.mqtt.internal.MqttChecks;
import io.gatling.mqtt.action.builder.CheckableSubscribeBuilder;
import io.gatling.mqtt.action.builder.SubscribeBuilder;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;

public final class SubscribeActionBuilder
implements ActionBuilder {
    private final SubscribeBuilder wrapped;

    SubscribeActionBuilder(SubscribeBuilder subscribeBuilder) {
        this.wrapped = subscribeBuilder;
    }

    @NonNull
    public SubscribeActionBuilder qosAtMostOnce() {
        return new SubscribeActionBuilder(this.wrapped.qosAtMostOnce());
    }

    @NonNull
    public SubscribeActionBuilder qosAtLeastOnce() {
        return new SubscribeActionBuilder(this.wrapped.qosAtLeastOnce());
    }

    @NonNull
    public SubscribeActionBuilder qosExactlyOnce() {
        return new SubscribeActionBuilder(this.wrapped.qosExactlyOnce());
    }

    @NonNull
    public Checkable await(long l) {
        return this.await(Duration.ofSeconds(l));
    }

    @NonNull
    public Checkable await(@NonNull Duration duration) {
        return new Checkable(this.wrapped.await(Converters.toScalaDuration((Duration)duration)));
    }

    @NonNull
    public Checkable expect(long l) {
        return this.expect(Duration.ofSeconds(l));
    }

    @NonNull
    public Checkable expect(@NonNull Duration duration) {
        return new Checkable(this.wrapped.expect(Converters.toScalaDuration((Duration)duration)));
    }

    public io.gatling.core.action.builder.ActionBuilder asScala() {
        return this.wrapped;
    }

    public static final class Checkable
    implements ActionBuilder {
        private final SubscribeBuilder wrapped;

        Checkable(SubscribeBuilder subscribeBuilder) {
            this.wrapped = subscribeBuilder;
        }

        @NonNull
        public SubscribeActionBuilder qosAtMostOnce() {
            return new SubscribeActionBuilder(this.wrapped.qosAtMostOnce());
        }

        @NonNull
        public SubscribeActionBuilder qosAtLeastOnce() {
            return new SubscribeActionBuilder(this.wrapped.qosAtLeastOnce());
        }

        @NonNull
        public SubscribeActionBuilder qosExactlyOnce() {
            return new SubscribeActionBuilder(this.wrapped.qosExactlyOnce());
        }

        @NonNull
        public Checkable check(CheckBuilder ... checkBuilderArray) {
            return this.check(Arrays.asList(checkBuilderArray));
        }

        @NonNull
        public Checkable check(@NonNull List<CheckBuilder> list) {
            return new Checkable(((CheckableSubscribeBuilder)this.wrapped).check(MqttChecks.toScalaChecks(list)));
        }

        public io.gatling.core.action.builder.ActionBuilder asScala() {
            return this.wrapped;
        }
    }
}

