/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractGatlingMojo;
import io.gatling.plugin.GatlingConstants;
import io.gatling.plugin.util.Fork;
import io.gatling.shared.cli.RecorderCliOptions;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.toolchain.Toolchain;

@Mojo(name="recorder", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public final class RecorderMojo
extends AbstractGatlingMojo {
    @Parameter(property="gatling.recorder.package", alias="pkg", defaultValue="${project.groupId}")
    private String packageName;
    @Parameter(property="gatling.recorder.className", alias="cn")
    private String className;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String format;
        Path simulationsDirectory;
        List testResourcesDirectories = this.mavenProject.getTestResources().stream().map(FileSet::getDirectory).map(x$0 -> Path.of(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
        if (testResourcesDirectories.isEmpty()) {
            throw new MojoExecutionException("Missing test resources directory");
        }
        Path testResourcesDirectory = (Path)testResourcesDirectories.get(0);
        List testSourceDirectories = this.mavenProject.getTestCompileSourceRoots().stream().map(x$0 -> Path.of(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
        Path scalaTestSourceDir = null;
        Path kotlinTestSourceDir = null;
        Path javaTestSourceDir = null;
        for (Path testSourceDirectory : testSourceDirectories) {
            if (testSourceDirectory.endsWith("scala")) {
                scalaTestSourceDir = testSourceDirectory;
                continue;
            }
            if (testSourceDirectory.endsWith("kotlin")) {
                kotlinTestSourceDir = testSourceDirectory;
                continue;
            }
            if (!testSourceDirectory.endsWith("java")) continue;
            javaTestSourceDir = testSourceDirectory;
        }
        if (scalaTestSourceDir != null) {
            simulationsDirectory = scalaTestSourceDir;
            format = "scala";
        } else if (kotlinTestSourceDir != null) {
            simulationsDirectory = kotlinTestSourceDir;
            format = "kotlin";
        } else if (javaTestSourceDir != null) {
            simulationsDirectory = javaTestSourceDir;
            format = null;
        } else {
            throw new MojoExecutionException("Unable to locate testCompileSourceRoot for neither Scala nor Kotlin nor Java");
        }
        try {
            List<String> testClasspath = this.buildTestClasspath();
            List<String> recorderArgs = this.recorderArgs(simulationsDirectory, format, testResourcesDirectory);
            Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            Fork forkedRecorder = this.newFork("io.gatling.recorder.GatlingRecorder", testClasspath, GatlingConstants.DEFAULT_JVM_OPTIONS_BASE, recorderArgs, toolchain, true, null);
            forkedRecorder.run();
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Recorder execution failed", e);
        }
    }

    private List<String> recorderArgs(Path simulationsDirectory, String format, Path testResourcesDirectory) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(List.of(RecorderCliOptions.SimulationsFolder.shortOption(), simulationsDirectory.toFile().getCanonicalPath()));
        if (format != null) {
            args.addAll(List.of(RecorderCliOptions.Format.shortOption(), format));
        }
        args.addAll(List.of(RecorderCliOptions.ResourcesFolder.shortOption(), testResourcesDirectory.toFile().getCanonicalPath()));
        args.addAll(List.of(RecorderCliOptions.Package.shortOption(), this.packageName));
        if (this.className != null) {
            args.addAll(List.of(RecorderCliOptions.ClassName.shortOption(), this.className));
        }
        return args;
    }
}

