/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractEnterpriseMojo;
import io.gatling.mojo.CommonLogMessage;
import io.gatling.mojo.UnsupportedClientMojoException;
import io.gatling.plugin.BatchEnterprisePlugin;
import io.gatling.plugin.EnterprisePlugin;
import io.gatling.plugin.EnterprisePluginProvider;
import io.gatling.plugin.PluginConfiguration;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.UnsupportedClientException;
import io.gatling.plugin.io.JavaPluginScanner;
import io.gatling.plugin.io.PluginIO;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.io.PluginScanner;
import io.gatling.plugin.model.BuildTool;
import java.net.URL;
import java.util.Scanner;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractEnterprisePluginMojo
extends AbstractEnterpriseMojo {
    @Parameter(defaultValue="https://cloud.gatling.io", readonly=true)
    protected URL enterpriseUrl;
    @Parameter(defaultValue="${env.GATLING_ENTERPRISE_API_TOKEN}", property="gatling.enterprise.apiToken")
    protected String apiToken;
    @Parameter(defaultValue="${env.GATLING_CONTROL_PLANE_URL}", property="gatling.enterprise.controlPlaneUrl")
    protected URL controlPlaneUrl;
    private final PluginLogger pluginLogger = new PluginLogger(){

        public void info(String message) {
            AbstractEnterprisePluginMojo.this.getLog().info((CharSequence)message);
        }

        public void error(String message) {
            AbstractEnterprisePluginMojo.this.getLog().error((CharSequence)message);
        }
    };
    private final Scanner scanner = new Scanner(System.in);
    private final PluginScanner pluginScanner = new JavaPluginScanner(this.scanner);
    private final PluginIO pluginIO = new PluginIO(){

        public PluginLogger getLogger() {
            return AbstractEnterprisePluginMojo.this.pluginLogger;
        }

        public PluginScanner getScanner() {
            return AbstractEnterprisePluginMojo.this.pluginScanner;
        }
    };

    private PluginConfiguration pluginConfiguration(Boolean forceBatchMode) throws MojoFailureException {
        if (this.apiToken == null) {
            String msg = "Missing API token\nAn API token is required to call the Gatling Enterprise server; see https://gatling.io/docs/enterprise/cloud/reference/admin/api_tokens/ and create a token with the role 'Configure'.\n" + CommonLogMessage.missingConfiguration("API token", "apiToken", "gatling.enterprise.apiToken", "GATLING_ENTERPRISE_API_TOKEN", "MY_API_TOKEN_VALUE");
            throw new MojoFailureException(msg);
        }
        return new PluginConfiguration(this.enterpriseUrl, this.apiToken, this.controlPlaneUrl, BuildTool.MAVEN, this.pluginVersion(), forceBatchMode, this.pluginIO);
    }

    protected BatchEnterprisePlugin initBatchEnterprisePlugin() throws MojoFailureException {
        try {
            return EnterprisePluginProvider.getBatchInstance((PluginConfiguration)this.pluginConfiguration(true));
        }
        catch (UnsupportedClientException e) {
            throw new UnsupportedClientMojoException(e);
        }
        catch (EnterprisePluginException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    protected EnterprisePlugin initEnterprisePlugin(Boolean forceBatchMode) throws MojoFailureException {
        try {
            return EnterprisePluginProvider.getInstance((PluginConfiguration)this.pluginConfiguration(forceBatchMode));
        }
        catch (UnsupportedClientException e) {
            throw new UnsupportedClientMojoException(e);
        }
        catch (EnterprisePluginException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

