/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.UnsupportedJavaVersionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public final class RecoverEnterprisePluginException {
    static <R> R handle(EnterprisePluginExceptionFunction<R> f, Log log) throws MojoFailureException {
        try {
            return f.apply();
        }
        catch (UnsupportedJavaVersionException e) {
            String msg = e.getMessage() + "\nIn order to target the supported Java version, please use the following Maven setting:\n<maven.compiler.release>" + e.supportedVersion + "</maven.compiler.release>\nSee also the Maven compiler plugin documentation: https://maven.apache.org/plugins/maven-compiler-plugin/examples/set-compiler-release.html \nAlternatively, the reported class may come from your project's dependencies, published targeting Java " + e.version + ". In this case you need to use dependencies which target Java " + e.supportedVersion + " or lower.";
            throw new MojoFailureException(msg);
        }
        catch (EnterprisePluginException e) {
            throw new MojoFailureException("Unhandled Gatling Enterprise plugin exception: " + e.getMessage(), (Throwable)e);
        }
    }

    @FunctionalInterface
    public static interface EnterprisePluginExceptionFunction<R> {
        public R apply() throws EnterprisePluginException;
    }
}

