/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractEnterprisePluginMojo;
import io.gatling.mojo.CommonLogMessage;
import io.gatling.mojo.RecoverEnterprisePluginException;
import io.gatling.plugin.BatchEnterprisePlugin;
import java.io.File;
import java.util.UUID;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Execute(goal="enterprisePackage")
@Mojo(name="enterpriseUpload")
public final class EnterpriseUploadMojo
extends AbstractEnterprisePluginMojo {
    @Parameter(property="gatling.enterprise.packageId")
    private String packageId;
    @Parameter(property="gatling.enterprise.simulationId")
    private String simulationId;

    public void execute() throws MojoFailureException {
        if (this.packageId == null && this.simulationId == null) {
            String msg = "Missing packageID\nYou must configure the ID of an existing package in Gatling Enterprise; see https://gatling.io/docs/enterprise/cloud/reference/user/package_conf/ \n" + CommonLogMessage.missingConfiguration("package ID", "packageId", "gatling.enterprise.packageId", null, "MY_PACKAGE_ID") + "Alternately, if you don't configure a packageId, you can configure the simulationId of an existing simulation on Gatling Enterprise: your code will be uploaded to the package used by that simulation.";
            throw new MojoFailureException(msg);
        }
        File file = this.enterprisePackage();
        BatchEnterprisePlugin enterprisePlugin = this.initBatchEnterprisePlugin();
        RecoverEnterprisePluginException.handle(() -> this.packageId != null ? enterprisePlugin.uploadPackage(UUID.fromString(this.packageId), file) : enterprisePlugin.uploadPackageWithSimulationId(UUID.fromString(this.simulationId), file), this.getLog());
        this.getLog().info((CharSequence)"Package successfully uploaded");
    }
}

