/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import java.net.URL;

public final class CommonLogMessage {
    private CommonLogMessage() {
    }

    public static String simulationStartSuccess(URL enterpriseUrl, String reportsPath) {
        return "Simulation successfully started; reports are available at " + String.valueOf(enterpriseUrl) + reportsPath;
    }

    public static String missingConfiguration(String commonName, String confName, String sysPropName, String envVarName, String sampleValue) {
        Object envVarMsg = envVarName != null ? " in the environment variable " + envVarName + ", pass it" : "";
        String firstLine = String.format("Specify the %s you want to use%s with -D%s=<%s>, or add the configuration to your pom.xml, e.g.:\n", commonName, envVarMsg, sysPropName, confName);
        return firstLine + CommonLogMessage.pluginConfiguration(confName, sampleValue);
    }

    private static String pluginConfiguration(String confName, String confValue) {
        return "<plugin>\n  <groupId>io.gatling</groupId>\n  <artifactId>gatling-maven-plugin</artifactId>\n  <configuration>\n    <" + confName + ">" + confValue + "</" + confName + ">\n  </configuration>\n</plugin>";
    }
}

