/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractEnterprisePluginMojo;
import io.gatling.mojo.CommonLogMessage;
import io.gatling.mojo.RecoverEnterprisePluginException;
import io.gatling.plugin.BatchEnterprisePlugin;
import io.gatling.plugin.configuration.PackageConfiguration;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import java.io.File;
import java.util.UUID;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Execute(goal="enterprisePackage")
@Mojo(name="enterpriseUpload")
public final class EnterpriseUploadMojo
extends AbstractEnterprisePluginMojo {
    @Parameter(property="gatling.enterprise.packageId")
    private String packageId;
    @Parameter(property="gatling.enterprise.simulationId")
    private String simulationId;

    public void execute() throws MojoFailureException {
        BatchEnterprisePlugin enterprisePlugin = this.initBatchEnterprisePlugin();
        String jsonConfig = PackageConfiguration.loadToJson((File)this.mavenProject.getBasedir());
        if (jsonConfig != null) {
            try {
                this.getLog().info((CharSequence)"Package configuration file detected, applying it.");
                this.packageId = enterprisePlugin.uploadPackageConfiguration(jsonConfig).toString();
                this.getLog().info((CharSequence)("Package id: " + this.packageId));
            }
            catch (EnterprisePluginException e) {
                throw new MojoFailureException("Failed to upload package configuration", (Throwable)e);
            }
        }
        if (this.packageId == null && this.simulationId == null) {
            String msg = "Missing packageID\nYou must configure the ID of an existing package in Gatling Enterprise; see https://gatling.io/docs/enterprise/cloud/reference/user/package_conf/ \n" + CommonLogMessage.missingConfiguration("package ID", "packageId", "gatling.enterprise.packageId", null, "MY_PACKAGE_ID") + "Alternately, if you don't configure a packageId, you can configure the simulationId of an existing simulation on Gatling Enterprise: your code will be uploaded to the package used by that simulation.";
            throw new MojoFailureException(msg);
        }
        File file = this.enterprisePackage();
        RecoverEnterprisePluginException.handle(() -> this.packageId != null ? enterprisePlugin.uploadPackage(UUID.fromString(this.packageId), file) : enterprisePlugin.uploadPackageWithSimulationId(UUID.fromString(this.simulationId), file), this.getLog());
        this.getLog().info((CharSequence)"Package successfully uploaded");
    }
}

